/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.appliers;

import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableFlowNode;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableProcess;
import io.camunda.zeebe.engine.state.TypedEventApplier;
import io.camunda.zeebe.engine.state.immutable.ProcessState;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.engine.state.mutable.MutableElementInstanceState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessState;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceCreationRecord;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceCreationIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import java.util.List;
import org.agrona.DirectBuffer;

final class ProcessInstanceCreationCreatedApplier
implements TypedEventApplier<ProcessInstanceCreationIntent, ProcessInstanceCreationRecord> {
    private final ProcessState processState;
    private final MutableElementInstanceState elementInstanceState;

    public ProcessInstanceCreationCreatedApplier(MutableProcessState processState, MutableElementInstanceState elementInstanceState) {
        this.processState = processState;
        this.elementInstanceState = elementInstanceState;
    }

    @Override
    public void applyState(long key, ProcessInstanceCreationRecord value) {
        if (value.hasStartInstructions()) {
            ExecutableProcess process = this.processState.getProcessByKey(value.getProcessDefinitionKey()).getProcess();
            ElementInstance processInstance = this.elementInstanceState.getInstance(value.getProcessInstanceKey());
            value.getStartInstructions().stream().map(instruction -> process.getElementById(instruction.getElementId())).filter(element -> element.getElementType().equals((Object)BpmnElementType.PARALLEL_GATEWAY)).map(ExecutableFlowNode.class::cast).forEach(element -> {
                DirectBuffer parentElementId = element.getFlowScope().getId();
                ElementInstance flowScope = this.findParentFlowScope(processInstance, parentElementId);
                this.incrementNumberOfTakenSequenceFlows((ExecutableFlowNode)element, flowScope);
            });
        }
    }

    private ElementInstance findParentFlowScope(ElementInstance processInstance, DirectBuffer targetElementId) {
        if (processInstance.getValue().getElementIdBuffer().equals(targetElementId)) {
            return processInstance;
        }
        return this.findFlowScopeInChildren(processInstance, targetElementId);
    }

    private ElementInstance findFlowScopeInChildren(ElementInstance processInstance, DirectBuffer targetElementId) {
        ElementInstance found = null;
        List<ElementInstance> children = this.elementInstanceState.getChildren(processInstance.getKey());
        for (ElementInstance childInstance : children) {
            if (childInstance.getValue().getElementIdBuffer().equals(targetElementId)) {
                found = childInstance;
                break;
            }
            found = this.findFlowScopeInChildren(childInstance, targetElementId);
            if (found == null) continue;
            break;
        }
        return found;
    }

    private void incrementNumberOfTakenSequenceFlows(ExecutableFlowNode element, ElementInstance flowScope) {
        element.getIncoming().forEach(incoming -> this.elementInstanceState.incrementNumberOfTakenSequenceFlows(flowScope.getKey(), element.getId(), incoming.getId()));
    }
}

