/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.appliers;

import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableFlowNode;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableSequenceFlow;
import io.camunda.zeebe.engine.state.TypedEventApplier;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.engine.state.mutable.MutableElementInstanceState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessState;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;

final class ProcessInstanceSequenceFlowTakenApplier
implements TypedEventApplier<ProcessInstanceIntent, ProcessInstanceRecord> {
    private final MutableElementInstanceState elementInstanceState;
    private final MutableProcessState processState;

    public ProcessInstanceSequenceFlowTakenApplier(MutableElementInstanceState elementInstanceState, MutableProcessState processState) {
        this.elementInstanceState = elementInstanceState;
        this.processState = processState;
    }

    @Override
    public void applyState(long key, ProcessInstanceRecord value) {
        ElementInstance flowScopeInstance = this.elementInstanceState.getInstance(value.getFlowScopeKey());
        flowScopeInstance.incrementActiveSequenceFlows();
        this.elementInstanceState.updateInstance(flowScopeInstance);
        ExecutableSequenceFlow sequenceFlow = this.processState.getFlowElement(value.getProcessDefinitionKey(), value.getElementIdBuffer(), ExecutableSequenceFlow.class);
        ExecutableFlowNode target = sequenceFlow.getTarget();
        if (target.getElementType() == BpmnElementType.PARALLEL_GATEWAY) {
            this.elementInstanceState.incrementNumberOfTakenSequenceFlows(value.getFlowScopeKey(), target.getId(), sequenceFlow.getId());
        }
        if (target.getElementType() == BpmnElementType.INCLUSIVE_GATEWAY) {
            this.elementInstanceState.incrementNumberOfTakenSequenceFlows(value.getFlowScopeKey(), target.getId(), sequenceFlow.getId());
        }
    }
}

