/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.management;

import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.sbe.CompositeDecoderFlyweight;

public final class LargeGroupSizeEncodingDecoder
implements CompositeDecoderFlyweight {
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 0;
    public static final String SEMANTIC_VERSION = "8.2.23";
    public static final int ENCODED_LENGTH = 8;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private int offset;
    private DirectBuffer buffer;

    public LargeGroupSizeEncodingDecoder wrap(DirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        return this;
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public int encodedLength() {
        return 8;
    }

    public int sbeSchemaId() {
        return 1;
    }

    public int sbeSchemaVersion() {
        return 0;
    }

    public static int blockLengthEncodingOffset() {
        return 0;
    }

    public static int blockLengthEncodingLength() {
        return 2;
    }

    public static int blockLengthSinceVersion() {
        return 0;
    }

    public static int blockLengthNullValue() {
        return 65535;
    }

    public static int blockLengthMinValue() {
        return 0;
    }

    public static int blockLengthMaxValue() {
        return 65534;
    }

    public int blockLength() {
        return this.buffer.getShort(this.offset + 0, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
    }

    public static int numInGroupEncodingOffset() {
        return 2;
    }

    public static int numInGroupEncodingLength() {
        return 2;
    }

    public static int numInGroupSinceVersion() {
        return 0;
    }

    public static int numInGroupNullValue() {
        return 65535;
    }

    public static int numInGroupMinValue() {
        return 0;
    }

    public static int numInGroupMaxValue() {
        return 65534;
    }

    public int numInGroup() {
        return this.buffer.getShort(this.offset + 2, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
    }

    public static int numGroupsEncodingOffset() {
        return 4;
    }

    public static int numGroupsEncodingLength() {
        return 2;
    }

    public static int numGroupsSinceVersion() {
        return 0;
    }

    public static int numGroupsNullValue() {
        return 65535;
    }

    public static int numGroupsMinValue() {
        return 0;
    }

    public static int numGroupsMaxValue() {
        return 65534;
    }

    public int numGroups() {
        return this.buffer.getShort(this.offset + 4, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
    }

    public static int numVarDataFieldsEncodingOffset() {
        return 6;
    }

    public static int numVarDataFieldsEncodingLength() {
        return 2;
    }

    public static int numVarDataFieldsSinceVersion() {
        return 0;
    }

    public static int numVarDataFieldsNullValue() {
        return 65535;
    }

    public static int numVarDataFieldsMinValue() {
        return 0;
    }

    public static int numVarDataFieldsMaxValue() {
        return 65534;
    }

    public int numVarDataFields() {
        return this.buffer.getShort(this.offset + 6, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        builder.append('(');
        builder.append("blockLength=");
        builder.append(this.blockLength());
        builder.append('|');
        builder.append("numInGroup=");
        builder.append(this.numInGroup());
        builder.append('|');
        builder.append("numGroups=");
        builder.append(this.numGroups());
        builder.append('|');
        builder.append("numVarDataFields=");
        builder.append(this.numVarDataFields());
        builder.append(')');
        return builder;
    }
}

