/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record.intent;

import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceRelatedIntent;

public enum JobIntent implements ProcessInstanceRelatedIntent
{
    CREATED(0),
    COMPLETE(1, false),
    COMPLETED(2),
    TIME_OUT(3),
    TIMED_OUT(4),
    FAIL(5, false),
    FAILED(6),
    UPDATE_RETRIES(7, false),
    RETRIES_UPDATED(8),
    CANCEL(9),
    CANCELED(10),
    THROW_ERROR(11, false),
    ERROR_THROWN(12),
    RECUR_AFTER_BACKOFF(13),
    RECURRED_AFTER_BACKOFF(14);

    private final short value;
    private final boolean shouldBanInstance;

    private JobIntent(short value) {
        this(value, true);
    }

    private JobIntent(short value, boolean shouldBanInstance) {
        this.value = value;
        this.shouldBanInstance = shouldBanInstance;
    }

    public short getIntent() {
        return this.value;
    }

    public static Intent from(short value) {
        switch (value) {
            case 0: {
                return CREATED;
            }
            case 1: {
                return COMPLETE;
            }
            case 2: {
                return COMPLETED;
            }
            case 3: {
                return TIME_OUT;
            }
            case 4: {
                return TIMED_OUT;
            }
            case 5: {
                return FAIL;
            }
            case 6: {
                return FAILED;
            }
            case 7: {
                return UPDATE_RETRIES;
            }
            case 8: {
                return RETRIES_UPDATED;
            }
            case 9: {
                return CANCEL;
            }
            case 10: {
                return CANCELED;
            }
            case 11: {
                return THROW_ERROR;
            }
            case 12: {
                return ERROR_THROWN;
            }
            case 13: {
                return RECUR_AFTER_BACKOFF;
            }
            case 14: {
                return RECURRED_AFTER_BACKOFF;
            }
        }
        return UNKNOWN;
    }

    @Override
    public short value() {
        return this.value;
    }

    @Override
    public boolean isEvent() {
        switch (this) {
            case CREATED: 
            case COMPLETED: 
            case TIMED_OUT: 
            case FAILED: 
            case RETRIES_UPDATED: 
            case CANCELED: 
            case ERROR_THROWN: 
            case RECURRED_AFTER_BACKOFF: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean shouldBanInstanceOnError() {
        return this.shouldBanInstance;
    }
}

