/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.record.value.decision;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.camunda.zeebe.msgpack.property.ArrayProperty;
import io.camunda.zeebe.msgpack.property.BaseProperty;
import io.camunda.zeebe.msgpack.property.IntegerProperty;
import io.camunda.zeebe.msgpack.property.StringProperty;
import io.camunda.zeebe.msgpack.value.BaseValue;
import io.camunda.zeebe.msgpack.value.ValueArray;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.impl.record.value.decision.EvaluatedOutputRecord;
import io.camunda.zeebe.protocol.record.value.EvaluatedOutputValue;
import io.camunda.zeebe.protocol.record.value.MatchedRuleValue;
import io.camunda.zeebe.util.buffer.BufferUtil;
import io.camunda.zeebe.util.buffer.BufferWriter;
import java.util.ArrayList;
import java.util.List;
import org.agrona.DirectBuffer;

public final class MatchedRuleRecord
extends UnifiedRecordValue
implements MatchedRuleValue {
    private final StringProperty ruleIdProp = new StringProperty("ruleId");
    private final IntegerProperty ruleIndexProp = new IntegerProperty("ruleIndex");
    private final ArrayProperty<EvaluatedOutputRecord> evaluatedOutputsProp = new ArrayProperty("evaluatedOutputs", (BaseValue)new EvaluatedOutputRecord());

    public MatchedRuleRecord() {
        super(3);
        this.declareProperty((BaseProperty)this.ruleIdProp).declareProperty((BaseProperty)this.ruleIndexProp).declareProperty(this.evaluatedOutputsProp);
    }

    public String getRuleId() {
        return BufferUtil.bufferAsString((DirectBuffer)this.ruleIdProp.getValue());
    }

    public MatchedRuleRecord setRuleId(String ruleId) {
        this.ruleIdProp.setValue(ruleId);
        return this;
    }

    public int getRuleIndex() {
        return this.ruleIndexProp.getValue();
    }

    public MatchedRuleRecord setRuleIndex(int ruleIndex) {
        this.ruleIndexProp.setValue(ruleIndex);
        return this;
    }

    public List<EvaluatedOutputValue> getEvaluatedOutputs() {
        ArrayList<EvaluatedOutputValue> evaluatedOutputs = new ArrayList<EvaluatedOutputValue>();
        for (EvaluatedOutputRecord evaluatedOutput : this.evaluatedOutputsProp) {
            EvaluatedOutputRecord copyRecord = new EvaluatedOutputRecord();
            DirectBuffer copyBuffer = BufferUtil.createCopy((BufferWriter)evaluatedOutput);
            copyRecord.wrap(copyBuffer);
            evaluatedOutputs.add(copyRecord);
        }
        return evaluatedOutputs;
    }

    @JsonIgnore
    public DirectBuffer getRuleIdBuffer() {
        return this.ruleIdProp.getValue();
    }

    @JsonIgnore
    public ValueArray<EvaluatedOutputRecord> evaluatedOutputs() {
        return this.evaluatedOutputsProp;
    }
}

