/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.record.value.processinstance;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.camunda.zeebe.msgpack.property.ArrayProperty;
import io.camunda.zeebe.msgpack.property.BaseProperty;
import io.camunda.zeebe.msgpack.property.LongProperty;
import io.camunda.zeebe.msgpack.value.BaseValue;
import io.camunda.zeebe.msgpack.value.LongValue;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceModificationActivateInstruction;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceModificationTerminateInstruction;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceModificationRecordValue;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public final class ProcessInstanceModificationRecord
extends UnifiedRecordValue
implements ProcessInstanceModificationRecordValue {
    private final LongProperty processInstanceKeyProperty = new LongProperty("processInstanceKey");
    private final ArrayProperty<ProcessInstanceModificationTerminateInstruction> terminateInstructionsProperty = new ArrayProperty("terminateInstructions", (BaseValue)new ProcessInstanceModificationTerminateInstruction());
    private final ArrayProperty<ProcessInstanceModificationActivateInstruction> activateInstructionsProperty = new ArrayProperty("activateInstructions", (BaseValue)new ProcessInstanceModificationActivateInstruction());
    @Deprecated(since="8.1.3")
    private final ArrayProperty<LongValue> activatedElementInstanceKeys = new ArrayProperty("activatedElementInstanceKeys", (BaseValue)new LongValue());

    public ProcessInstanceModificationRecord() {
        super(4);
        this.declareProperty((BaseProperty)this.processInstanceKeyProperty).declareProperty(this.terminateInstructionsProperty).declareProperty(this.activateInstructionsProperty).declareProperty(this.activatedElementInstanceKeys);
    }

    public List<ProcessInstanceModificationRecordValue.ProcessInstanceModificationTerminateInstructionValue> getTerminateInstructions() {
        return this.terminateInstructionsProperty.stream().map(element -> {
            ProcessInstanceModificationTerminateInstruction elementCopy = new ProcessInstanceModificationTerminateInstruction();
            elementCopy.copy((ProcessInstanceModificationRecordValue.ProcessInstanceModificationTerminateInstructionValue)element);
            return elementCopy;
        }).toList();
    }

    public List<ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue> getActivateInstructions() {
        return this.activateInstructionsProperty.stream().map(element -> {
            ProcessInstanceModificationActivateInstruction elementCopy = new ProcessInstanceModificationActivateInstruction();
            elementCopy.copy((ProcessInstanceModificationActivateInstruction)((Object)element));
            return elementCopy;
        }).toList();
    }

    public Set<Long> getAncestorScopeKeys() {
        Set<Long> activatedElementInstanceKeys = this.activatedElementInstanceKeys.stream().map(LongValue::getValue).collect(Collectors.toSet());
        activatedElementInstanceKeys.addAll(this.getActivateInstructions().stream().map(ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue::getAncestorScopeKeys).flatMap(Collection::stream).collect(Collectors.toSet()));
        return activatedElementInstanceKeys;
    }

    @JsonIgnore
    public boolean hasTerminateInstructions() {
        return !this.terminateInstructionsProperty.isEmpty();
    }

    public ProcessInstanceModificationRecord addTerminateInstruction(ProcessInstanceModificationRecordValue.ProcessInstanceModificationTerminateInstructionValue terminateInstruction) {
        ((ProcessInstanceModificationTerminateInstruction)this.terminateInstructionsProperty.add()).copy(terminateInstruction);
        return this;
    }

    @JsonIgnore
    public boolean hasActivateInstructions() {
        return !this.activateInstructionsProperty.isEmpty();
    }

    public ProcessInstanceModificationRecord addActivateInstruction(ProcessInstanceModificationActivateInstruction activateInstruction) {
        ((ProcessInstanceModificationActivateInstruction)this.activateInstructionsProperty.add()).copy(activateInstruction);
        return this;
    }

    public long getProcessInstanceKey() {
        return this.processInstanceKeyProperty.getValue();
    }

    public ProcessInstanceModificationRecord setProcessInstanceKey(long processInstanceKey) {
        this.processInstanceKeyProperty.setValue(processInstanceKey);
        return this;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }
}

