/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.record.value.signal;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.camunda.zeebe.msgpack.property.BaseProperty;
import io.camunda.zeebe.msgpack.property.DocumentProperty;
import io.camunda.zeebe.msgpack.property.StringProperty;
import io.camunda.zeebe.protocol.impl.encoding.MsgPackConverter;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.record.value.SignalRecordValue;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.Map;
import org.agrona.DirectBuffer;

public final class SignalRecord
extends UnifiedRecordValue
implements SignalRecordValue {
    private final StringProperty signalNameProp = new StringProperty("signalName");
    private final DocumentProperty variablesProp = new DocumentProperty("variables");

    public SignalRecord() {
        super(2);
        this.declareProperty((BaseProperty)this.signalNameProp).declareProperty((BaseProperty)this.variablesProp);
    }

    public void wrap(SignalRecord record) {
        this.setSignalName(record.getSignalNameBuffer());
        this.setVariables(record.getVariablesBuffer());
    }

    public String getSignalName() {
        return BufferUtil.bufferAsString((DirectBuffer)this.signalNameProp.getValue());
    }

    public SignalRecord setSignalName(String signalName) {
        this.signalNameProp.setValue(signalName);
        return this;
    }

    public SignalRecord setSignalName(DirectBuffer signalName) {
        this.signalNameProp.setValue(signalName);
        return this;
    }

    @JsonIgnore
    public DirectBuffer getSignalNameBuffer() {
        return this.signalNameProp.getValue();
    }

    public Map<String, Object> getVariables() {
        return MsgPackConverter.convertToMap(this.variablesProp.getValue());
    }

    public SignalRecord setVariables(DirectBuffer variables) {
        this.variablesProp.setValue(variables);
        return this;
    }

    @JsonIgnore
    public DirectBuffer getVariablesBuffer() {
        return this.variablesProp.getValue();
    }
}

