/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.journal.file;

import io.camunda.zeebe.journal.JournalMetaStore;
import io.camunda.zeebe.journal.file.FlushableSegment;
import java.util.Collection;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SegmentsFlusher {
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentsFlusher.class);
    private final JournalMetaStore metaStore;
    private long lastFlushedIndex;

    SegmentsFlusher(JournalMetaStore metaStore) {
        this.metaStore = Objects.requireNonNull(metaStore, "must specify a meta store");
        this.lastFlushedIndex = metaStore.loadLastFlushedIndex();
    }

    void setLastFlushedIndex(long lastFlushedIndex) {
        this.lastFlushedIndex = lastFlushedIndex;
        this.metaStore.storeLastFlushedIndex(lastFlushedIndex);
    }

    long nextFlushIndex() {
        return this.lastFlushedIndex + 1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flush(Collection<? extends FlushableSegment> dirtySegments) {
        block5: {
            int segmentsCount = dirtySegments.size();
            long flushedIndex = -1L;
            if (segmentsCount == 0) {
                LOGGER.debug("No segments to flush for index {}; there may be nothing to flush", (Object)flushedIndex);
                return;
            }
            try {
                for (FlushableSegment flushableSegment : dirtySegments) {
                    long lastSegmentIndex = flushableSegment.lastIndex();
                    if (!flushableSegment.flush()) continue;
                    flushedIndex = lastSegmentIndex;
                }
                if (flushedIndex <= this.lastFlushedIndex) break block5;
                this.setLastFlushedIndex(flushedIndex);
            }
            catch (Throwable throwable) {
                if (flushedIndex > this.lastFlushedIndex) {
                    this.setLastFlushedIndex(flushedIndex);
                    LOGGER.trace("Flushed {} segment(s), from index {} to index {}", new Object[]{segmentsCount, this.lastFlushedIndex, flushedIndex});
                }
                throw throwable;
            }
            LOGGER.trace("Flushed {} segment(s), from index {} to index {}", new Object[]{segmentsCount, this.lastFlushedIndex, flushedIndex});
        }
    }
}

