/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.exporter.stream;

import io.camunda.zeebe.protocol.record.ValueType;
import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;

public final class ExporterMetrics {
    private static final Counter EXPORTER_EVENTS = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("zeebe")).name("exporter_events_total")).help("Number of events processed by exporter")).labelNames(new String[]{"action", "partition", "valueType"})).register();
    private static final Gauge LAST_EXPORTED_POSITION = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("zeebe")).name("exporter_last_exported_position")).help("The last exported position by exporter and partition.")).labelNames(new String[]{"exporter", "partition"})).register();
    private static final Gauge LAST_UPDATED_EXPORTED_POSITION = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("zeebe")).name("exporter_last_updated_exported_position")).help("The last exported position which was also updated/commited by the exporter.")).labelNames(new String[]{"exporter", "partition"})).register();
    private final String partitionIdLabel;

    public ExporterMetrics(int partitionId) {
        this.partitionIdLabel = String.valueOf(partitionId);
    }

    private void event(String action, ValueType valueType) {
        ((Counter.Child)EXPORTER_EVENTS.labels(new String[]{action, this.partitionIdLabel, valueType.name()})).inc();
    }

    public void eventExported(ValueType valueType) {
        this.event("exported", valueType);
    }

    public void eventSkipped(ValueType valueType) {
        this.event("skipped", valueType);
    }

    public void setLastUpdatedExportedPosition(String exporter, long position) {
        ((Gauge.Child)LAST_UPDATED_EXPORTED_POSITION.labels(new String[]{exporter, this.partitionIdLabel})).set((double)position);
    }

    public void setLastExportedPosition(String exporter, long position) {
        ((Gauge.Child)LAST_EXPORTED_POSITION.labels(new String[]{exporter, this.partitionIdLabel})).set((double)position);
    }
}

