/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.partitioning;

import io.atomix.raft.partition.PartitionDistributor;
import io.atomix.raft.partition.RaftPartitionGroup;
import io.atomix.raft.partition.RoundRobinPartitionDistributor;
import io.atomix.raft.storage.log.DelayedFlusher;
import io.atomix.raft.storage.log.RaftLogFlusher;
import io.atomix.raft.zeebe.EntryValidator;
import io.atomix.utils.concurrent.Scheduler;
import io.camunda.zeebe.broker.Loggers;
import io.camunda.zeebe.broker.partitioning.distribution.FixedPartitionDistributor;
import io.camunda.zeebe.broker.partitioning.distribution.FixedPartitionDistributorBuilder;
import io.camunda.zeebe.broker.raft.ZeebeEntryValidator;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.configuration.ClusterCfg;
import io.camunda.zeebe.broker.system.configuration.DataCfg;
import io.camunda.zeebe.broker.system.configuration.ExperimentalCfg;
import io.camunda.zeebe.broker.system.configuration.NetworkCfg;
import io.camunda.zeebe.broker.system.configuration.PartitioningCfg;
import io.camunda.zeebe.broker.system.configuration.RaftCfg;
import io.camunda.zeebe.broker.system.configuration.partitioning.FixedPartitionCfg;
import io.camunda.zeebe.snapshots.ReceivableSnapshotStoreFactory;
import io.camunda.zeebe.util.FileUtil;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;

public final class RaftPartitionGroupFactory {
    public RaftPartitionGroup buildRaftPartitionGroup(BrokerCfg configuration, ReceivableSnapshotStoreFactory snapshotStoreFactory) {
        DataCfg dataConfiguration = configuration.getData();
        String rootDirectory = dataConfiguration.getDirectory();
        Path rootPath = Paths.get(rootDirectory, new String[0]);
        try {
            FileUtil.ensureDirectoryExists((Path)rootPath);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to create data directory", e);
        }
        Path raftDataDirectory = rootPath.resolve("raft-partition");
        try {
            FileUtil.ensureDirectoryExists((Path)raftDataDirectory);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to create Raft data directory", e);
        }
        ClusterCfg clusterCfg = configuration.getCluster();
        ExperimentalCfg experimentalCfg = configuration.getExperimental();
        DataCfg dataCfg = configuration.getData();
        NetworkCfg networkCfg = configuration.getNetwork();
        RaftLogFlusher.Factory flusherFactory = this.createFlusherFactory(clusterCfg.getRaft().getFlush(), experimentalCfg);
        PartitionDistributor partitionDistributor = this.buildPartitionDistributor(configuration.getExperimental().getPartitioning());
        RaftPartitionGroup.Builder partitionGroupBuilder = RaftPartitionGroup.builder((String)"raft-partition").withNumPartitions(clusterCfg.getPartitionsCount()).withPartitionSize(clusterCfg.getReplicationFactor()).withMembers(this.getRaftGroupMembers(clusterCfg)).withDataDirectory(raftDataDirectory.toFile()).withSnapshotStoreFactory(snapshotStoreFactory).withMaxAppendBatchSize((int)experimentalCfg.getMaxAppendBatchSizeInBytes()).withMaxAppendsPerFollower(experimentalCfg.getMaxAppendsPerFollower()).withEntryValidator((EntryValidator)new ZeebeEntryValidator()).withFlusherFactory(flusherFactory).withFreeDiskSpace(dataCfg.getDisk().getFreeSpace().getReplication().toBytes()).withJournalIndexDensity(dataCfg.getLogIndexDensity()).withPriorityElection(clusterCfg.getRaft().isEnablePriorityElection()).withPartitionDistributor(partitionDistributor).withElectionTimeout(clusterCfg.getElectionTimeout()).withHeartbeatInterval(clusterCfg.getHeartbeatInterval()).withRequestTimeout(experimentalCfg.getRaft().getRequestTimeout()).withSnapshotRequestTimeout(experimentalCfg.getRaft().getSnapshotRequestTimeout()).withMaxQuorumResponseTimeout(experimentalCfg.getRaft().getMaxQuorumResponseTimeout()).withMinStepDownFailureCount(experimentalCfg.getRaft().getMinStepDownFailureCount()).withPreferSnapshotReplicationThreshold(experimentalCfg.getRaft().getPreferSnapshotReplicationThreshold()).withPreallocateSegmentFiles(experimentalCfg.getRaft().isPreallocateSegmentFiles());
        int maxMessageSize = (int)networkCfg.getMaxMessageSizeInBytes();
        long segmentSize = dataCfg.getLogSegmentSizeInBytes();
        if (segmentSize < (long)maxMessageSize) {
            throw new IllegalArgumentException(String.format("Expected the raft segment size greater than the max message size of %s, but was %s.", maxMessageSize, segmentSize));
        }
        partitionGroupBuilder.withSegmentSize(segmentSize);
        return partitionGroupBuilder.build();
    }

    private RaftLogFlusher.Factory createFlusherFactory(RaftCfg.FlushConfig config, ExperimentalCfg experimental) {
        if (experimental.isDisableExplicitRaftFlush()) {
            return this.createFlusherFactory(new RaftCfg.FlushConfig(false, Duration.ZERO));
        }
        return this.createFlusherFactory(config);
    }

    private RaftLogFlusher.Factory createFlusherFactory(RaftCfg.FlushConfig config) {
        if (config.enabled()) {
            Duration delayTime = config.delayTime();
            if (delayTime.isZero()) {
                return RaftLogFlusher.Factory::direct;
            }
            return threadFactory -> new DelayedFlusher((Scheduler)threadFactory.createContext(), delayTime);
        }
        Loggers.RAFT.warn("Explicit Raft flush is disabled. Data will be flushed to disk only before a snapshot is\ntaken. This is generally unsafe and could lead to data loss or corruption. Make sure to\nread the documentation regarding this feature.");
        return RaftLogFlusher.Factory::noop;
    }

    private List<String> getRaftGroupMembers(ClusterCfg clusterCfg) {
        int clusterSize = clusterCfg.getClusterSize();
        ArrayList<String> members = new ArrayList<String>();
        for (int i = 0; i < clusterSize; ++i) {
            members.add(Integer.toString(i));
        }
        return members;
    }

    private PartitionDistributor buildPartitionDistributor(PartitioningCfg config) {
        switch (config.getScheme()) {
            case FIXED: {
                return this.buildFixedPartitionDistributor(config);
            }
        }
        return new RoundRobinPartitionDistributor();
    }

    private FixedPartitionDistributor buildFixedPartitionDistributor(PartitioningCfg config) {
        FixedPartitionDistributorBuilder distributionBuilder = new FixedPartitionDistributorBuilder("raft-partition");
        for (FixedPartitionCfg partition : config.getFixed()) {
            for (FixedPartitionCfg.NodeCfg node : partition.getNodes()) {
                distributionBuilder.assignMember(partition.getPartitionId(), node.getNodeId(), node.getPriority());
            }
        }
        return distributionBuilder.build();
    }
}

