/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.configuration;

import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.configuration.ConfigurationEntry;
import java.util.Set;

public final class ProcessingCfg
implements ConfigurationEntry {
    private static final int DEFAULT_PROCESSING_BATCH_LIMIT = 100;
    private Integer maxCommandsInBatch = 100;
    private Set<Long> skipPositions;

    @Override
    public void init(BrokerCfg globalConfig, String brokerBase) {
        if (this.maxCommandsInBatch < 1) {
            throw new IllegalArgumentException("maxCommandsInBatch must be >= 1 but was %s".formatted(this.maxCommandsInBatch));
        }
    }

    public int getMaxCommandsInBatch() {
        return this.maxCommandsInBatch;
    }

    public void setMaxCommandsInBatch(int maxCommandsInBatch) {
        this.maxCommandsInBatch = maxCommandsInBatch;
    }

    public Set<Long> skipPositions() {
        return this.skipPositions != null ? this.skipPositions : Set.of();
    }

    public void setSkipPositions(Set<Long> skipPositions) {
        this.skipPositions = skipPositions;
    }

    public String toString() {
        return "ProcessingCfg{maxCommandsInBatch=" + this.maxCommandsInBatch + "}";
    }
}

