/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions;

import io.camunda.zeebe.broker.exporter.stream.ExporterDirector;
import io.camunda.zeebe.broker.system.partitions.PartitionAdminControl;
import io.camunda.zeebe.broker.system.partitions.impl.AsyncSnapshotDirector;
import io.camunda.zeebe.broker.system.partitions.impl.PartitionProcessingState;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.logstreams.log.LogStream;
import io.camunda.zeebe.stream.impl.StreamProcessor;
import java.io.IOException;
import java.util.function.Supplier;

public class PartitionAdminControlImpl
implements PartitionAdminControl {
    private final Supplier<StreamProcessor> streamProcessorSupplier;
    private final Supplier<ExporterDirector> exporterDirectorSupplier;
    private final Supplier<AsyncSnapshotDirector> snapshotDirectorSupplier;
    private final Supplier<PartitionProcessingState> partitionProcessingStateSupplier;
    private final Supplier<ZeebeDb> zeebeDbSupplier;
    private final Supplier<LogStream> logStreamSupplier;

    public PartitionAdminControlImpl(Supplier<StreamProcessor> streamProcessorSupplier, Supplier<ExporterDirector> exporterDirectorSupplier, Supplier<AsyncSnapshotDirector> snapshotDirectorSupplier, Supplier<PartitionProcessingState> partitionProcessingStateSupplier, Supplier<ZeebeDb> zeebeDbSupplier, Supplier<LogStream> logStreamSupplier) {
        this.streamProcessorSupplier = streamProcessorSupplier;
        this.exporterDirectorSupplier = exporterDirectorSupplier;
        this.snapshotDirectorSupplier = snapshotDirectorSupplier;
        this.partitionProcessingStateSupplier = partitionProcessingStateSupplier;
        this.zeebeDbSupplier = zeebeDbSupplier;
        this.logStreamSupplier = logStreamSupplier;
    }

    @Override
    public StreamProcessor getStreamProcessor() {
        return this.streamProcessorSupplier.get();
    }

    @Override
    public ZeebeDb getZeebeDb() {
        return this.zeebeDbSupplier.get();
    }

    @Override
    public LogStream getLogStream() {
        return this.logStreamSupplier.get();
    }

    @Override
    public ExporterDirector getExporterDirector() {
        return this.exporterDirectorSupplier.get();
    }

    @Override
    public void triggerSnapshot() {
        this.snapshotDirectorSupplier.get().forceSnapshot();
    }

    @Override
    public boolean shouldProcess() {
        return this.partitionProcessingStateSupplier.get().shouldProcess();
    }

    @Override
    public boolean shouldExport() {
        return !this.partitionProcessingStateSupplier.get().isExportingPaused();
    }

    @Override
    public void pauseProcessing() throws IOException {
        this.partitionProcessingStateSupplier.get().pauseProcessing();
    }

    @Override
    public void resumeProcessing() throws IOException {
        this.partitionProcessingStateSupplier.get().resumeProcessing();
    }

    @Override
    public boolean pauseExporting() throws IOException {
        return this.partitionProcessingStateSupplier.get().pauseExporting();
    }

    @Override
    public boolean resumeExporting() throws IOException {
        return this.partitionProcessingStateSupplier.get().resumeExporting();
    }
}

