/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.roles;

import io.atomix.cluster.messaging.MessagingException;
import io.atomix.raft.RaftServer;
import io.atomix.raft.cluster.impl.DefaultRaftMember;
import io.atomix.raft.cluster.impl.RaftMemberContext;
import io.atomix.raft.impl.RaftContext;
import io.atomix.raft.protocol.AppendRequest;
import io.atomix.raft.protocol.AppendResponse;
import io.atomix.raft.protocol.RaftResponse;
import io.atomix.raft.protocol.VoteRequest;
import io.atomix.raft.protocol.VoteResponse;
import io.atomix.raft.roles.ActiveRole;
import io.atomix.raft.roles.RaftRole;
import io.atomix.raft.storage.log.IndexedRaftLogEntry;
import io.atomix.raft.utils.Quorum;
import io.atomix.utils.concurrent.Scheduled;
import java.time.Duration;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

public final class CandidateRole
extends ActiveRole {
    private Scheduled currentTimer;
    private int votingRound = 0;

    public CandidateRole(RaftContext context) {
        super(context);
    }

    @Override
    public synchronized CompletableFuture<RaftRole> start() {
        if (this.raft.getCluster().getActiveMemberStates().isEmpty()) {
            this.log.info("Single member cluster. Transitioning directly to leader.");
            this.raft.setTerm(this.raft.getTerm() + 1L);
            this.raft.setLastVotedFor(this.raft.getCluster().getLocalMember().memberId());
            this.raft.transition(RaftServer.Role.LEADER);
            return CompletableFuture.completedFuture(this);
        }
        return ((CompletableFuture)super.start().thenRun(this::startElection)).thenApply(v -> this);
    }

    @Override
    public synchronized CompletableFuture<Void> stop() {
        return super.stop().thenRun(this::cancelElection);
    }

    @Override
    public RaftServer.Role role() {
        return RaftServer.Role.CANDIDATE;
    }

    private void cancelElection() {
        this.raft.checkThread();
        if (this.currentTimer != null) {
            this.log.debug("Cancelling election");
            this.currentTimer.cancel();
        }
    }

    void startElection() {
        this.log.info("Starting election");
        this.sendVoteRequests();
    }

    private void sendVoteRequests() {
        ++this.votingRound;
        this.raft.checkThread();
        if (!this.isRunning()) {
            return;
        }
        if (this.currentTimer != null) {
            this.currentTimer.cancel();
        }
        this.raft.setTerm(this.raft.getTerm() + 1L);
        this.raft.setLastVotedFor(this.raft.getCluster().getLocalMember().memberId());
        AtomicBoolean complete = new AtomicBoolean();
        Set votingMembers = this.raft.getCluster().getActiveMemberStates().stream().map(RaftMemberContext::getMember).collect(Collectors.toSet());
        Quorum quorum = new Quorum(this.raft.getCluster().getQuorum(), elected -> {
            if (!this.isRunning()) {
                return;
            }
            complete.set(true);
            if (elected.booleanValue()) {
                this.raft.transition(RaftServer.Role.LEADER);
            } else {
                this.raft.transition(RaftServer.Role.FOLLOWER);
            }
        });
        Duration delay = this.raft.getElectionTimeout().plus(Duration.ofMillis(this.raft.getRandom().nextInt((int)this.raft.getElectionTimeout().toMillis())));
        this.currentTimer = this.raft.getThreadContext().schedule(delay, () -> {
            if (!complete.get()) {
                boolean shouldRetry;
                quorum.cancel();
                boolean bl = shouldRetry = this.votingRound <= 1;
                if (shouldRetry) {
                    this.log.debug("Election timed out. Restarting election.");
                    this.sendVoteRequests();
                    ++this.votingRound;
                } else {
                    this.log.debug("Second round of election timed out. Transitioning to follower.");
                    this.raft.transition(RaftServer.Role.FOLLOWER);
                }
            }
        });
        IndexedRaftLogEntry lastEntry = this.raft.getLog().getLastEntry();
        long lastTerm = lastEntry != null ? lastEntry.term() : 0L;
        this.log.debug("Requesting votes for term {}", (Object)this.raft.getTerm());
        for (DefaultRaftMember member : votingMembers) {
            this.log.debug("Requesting vote from {} for term {}", (Object)member, (Object)this.raft.getTerm());
            VoteRequest request = VoteRequest.builder().withTerm(this.raft.getTerm()).withCandidate(this.raft.getCluster().getLocalMember().memberId()).withLastLogIndex(lastEntry != null ? lastEntry.index() : 0L).withLastLogTerm(lastTerm).build();
            this.sendVoteRequestToMember(complete, quorum, member, request);
        }
    }

    private void sendVoteRequestToMember(AtomicBoolean complete, Quorum quorum, DefaultRaftMember member, VoteRequest request) {
        this.raft.getProtocol().vote(member.memberId(), request).whenCompleteAsync((response, error) -> {
            this.raft.checkThread();
            if (this.isRunning() && !complete.get()) {
                this.onVoteResponse(complete, quorum, member, request, (VoteResponse)response, (Throwable)error);
            }
        }, (Executor)this.raft.getThreadContext());
    }

    private void onVoteResponse(AtomicBoolean complete, Quorum quorum, DefaultRaftMember member, VoteRequest request, VoteResponse response, Throwable error) {
        if (error != null) {
            this.onVoteResponseError(complete, quorum, member, request, error);
        } else if (response.term() > this.raft.getTerm()) {
            this.log.debug("Received greater term from {}", (Object)member);
            this.raft.setTerm(response.term());
            complete.set(true);
            this.raft.transition(RaftServer.Role.FOLLOWER);
        } else if (!response.voted()) {
            this.log.debug("Received rejected vote from {}", (Object)member);
            quorum.fail();
        } else if (response.term() != this.raft.getTerm()) {
            this.log.debug("Received successful vote for a different term from {}", (Object)member);
            quorum.fail();
        } else {
            this.log.debug("Received successful vote from {}", (Object)member);
            quorum.succeed();
        }
    }

    private void onVoteResponseError(AtomicBoolean complete, Quorum quorum, DefaultRaftMember member, VoteRequest request, Throwable error) {
        if (error.getCause() instanceof MessagingException.NoRemoteHandler) {
            this.log.debug("Member {} is not ready to receive vote requests, will retry later.", (Object)member, (Object)error);
            if (this.isRunning() && !complete.get()) {
                this.raft.getThreadContext().schedule(Duration.ofMillis(150L), () -> this.sendVoteRequestToMember(complete, quorum, member, request));
            }
        } else {
            this.log.warn(error.getMessage());
            quorum.fail();
        }
    }

    @Override
    public CompletableFuture<AppendResponse> onAppend(AppendRequest request) {
        this.raft.checkThread();
        if (request.term() >= this.raft.getTerm()) {
            this.raft.setTerm(request.term());
            this.raft.transition(RaftServer.Role.FOLLOWER);
        }
        return super.onAppend(request);
    }

    @Override
    public CompletableFuture<VoteResponse> onVote(VoteRequest request) {
        this.raft.checkThread();
        this.logRequest(request);
        if (this.updateTermAndLeader(request.term(), null)) {
            CompletableFuture<VoteResponse> future = super.onVote(request);
            this.raft.transition(RaftServer.Role.FOLLOWER);
            return future;
        }
        if (request.candidate() == this.raft.getCluster().getLocalMember().memberId()) {
            return CompletableFuture.completedFuture(this.logResponse(((VoteResponse.Builder)VoteResponse.builder().withStatus(RaftResponse.Status.OK)).withTerm(this.raft.getTerm()).withVoted(true).build()));
        }
        return CompletableFuture.completedFuture(this.logResponse(((VoteResponse.Builder)VoteResponse.builder().withStatus(RaftResponse.Status.OK)).withTerm(this.raft.getTerm()).withVoted(false).build()));
    }
}

