package io.camunda.zeebe.shared.management.openapi.models;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.camunda.zeebe.shared.management.openapi.models.StateCode;
import java.time.OffsetDateTime;
import org.springframework.format.annotation.DateTimeFormat;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * Detailed info of the backup for a given partition.
 */
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)

@Schema(name = "PartitionBackupInfo", description = "Detailed info of the backup for a given partition.")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2023-05-03T10:37:20.802306354Z[Etc/UTC]")
public class PartitionBackupInfo {

  @JsonProperty("partitionId")
  private Integer partitionId;

  @JsonProperty("state")
  private StateCode state;

  @JsonProperty("failureReason")
  private String failureReason;

  @JsonProperty("createdAt")
  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime createdAt;

  @JsonProperty("lastUpdatedAt")
  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime lastUpdatedAt;

  @JsonProperty("snapshotId")
  private String snapshotId;

  @JsonProperty("checkpointPosition")
  private Long checkpointPosition;

  @JsonProperty("brokerId")
  private Integer brokerId;

  @JsonProperty("brokerVersion")
  private String brokerVersion;

  public PartitionBackupInfo partitionId(Integer partitionId) {
    this.partitionId = partitionId;
    return this;
  }

  /**
   * Get partitionId
   * @return partitionId
  */
  
  @Schema(name = "partitionId", accessMode = Schema.AccessMode.READ_ONLY, requiredMode = Schema.RequiredMode.REQUIRED)
  public Integer getPartitionId() {
    return partitionId;
  }

  public void setPartitionId(Integer partitionId) {
    this.partitionId = partitionId;
  }

  public PartitionBackupInfo state(StateCode state) {
    this.state = state;
    return this;
  }

  /**
   * Get state
   * @return state
  */
  @Valid 
  @Schema(name = "state", accessMode = Schema.AccessMode.READ_ONLY, requiredMode = Schema.RequiredMode.REQUIRED)
  public StateCode getState() {
    return state;
  }

  public void setState(StateCode state) {
    this.state = state;
  }

  public PartitionBackupInfo failureReason(String failureReason) {
    this.failureReason = failureReason;
    return this;
  }

  /**
   * Failure reason if stats is 'FAILED'
   * @return failureReason
  */
  
  @Schema(name = "failureReason", example = "", description = "Failure reason if stats is 'FAILED'", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  public String getFailureReason() {
    return failureReason;
  }

  public void setFailureReason(String failureReason) {
    this.failureReason = failureReason;
  }

  public PartitionBackupInfo createdAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
    return this;
  }

  /**
   * The timestamp at which the backup was started on this partition.
   * @return createdAt
  */
  @Valid 
  @Schema(name = "createdAt", accessMode = Schema.AccessMode.READ_ONLY, example = "2022-09-15T13:10:38.176514094Z", description = "The timestamp at which the backup was started on this partition.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public PartitionBackupInfo lastUpdatedAt(OffsetDateTime lastUpdatedAt) {
    this.lastUpdatedAt = lastUpdatedAt;
    return this;
  }

  /**
   * The timestamp at which the backup was last updated on this partition, e.g. changed state from IN_PROGRESS to COMPLETED. 
   * @return lastUpdatedAt
  */
  @Valid 
  @Schema(name = "lastUpdatedAt", accessMode = Schema.AccessMode.READ_ONLY, example = "2022-09-15T13:10:38.176514094Z", description = "The timestamp at which the backup was last updated on this partition, e.g. changed state from IN_PROGRESS to COMPLETED. ", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  public OffsetDateTime getLastUpdatedAt() {
    return lastUpdatedAt;
  }

  public void setLastUpdatedAt(OffsetDateTime lastUpdatedAt) {
    this.lastUpdatedAt = lastUpdatedAt;
  }

  public PartitionBackupInfo snapshotId(String snapshotId) {
    this.snapshotId = snapshotId;
    return this;
  }

  /**
   * The ID of the snapshot which is included in this backup.
   * @return snapshotId
  */
  
  @Schema(name = "snapshotId", accessMode = Schema.AccessMode.READ_ONLY, example = "238632143-55-690906332-690905294", description = "The ID of the snapshot which is included in this backup.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  public String getSnapshotId() {
    return snapshotId;
  }

  public void setSnapshotId(String snapshotId) {
    this.snapshotId = snapshotId;
  }

  public PartitionBackupInfo checkpointPosition(Long checkpointPosition) {
    this.checkpointPosition = checkpointPosition;
    return this;
  }

  /**
   * The position of the checkpoint for this backup.
   * @return checkpointPosition
  */
  
  @Schema(name = "checkpointPosition", accessMode = Schema.AccessMode.READ_ONLY, example = "10", description = "The position of the checkpoint for this backup.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  public Long getCheckpointPosition() {
    return checkpointPosition;
  }

  public void setCheckpointPosition(Long checkpointPosition) {
    this.checkpointPosition = checkpointPosition;
  }

  public PartitionBackupInfo brokerId(Integer brokerId) {
    this.brokerId = brokerId;
    return this;
  }

  /**
   * The ID of the broker from which the backup was taken for this partition.
   * minimum: 0
   * @return brokerId
  */
  @Min(0) 
  @Schema(name = "brokerId", accessMode = Schema.AccessMode.READ_ONLY, example = "0", description = "The ID of the broker from which the backup was taken for this partition.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  public Integer getBrokerId() {
    return brokerId;
  }

  public void setBrokerId(Integer brokerId) {
    this.brokerId = brokerId;
  }

  public PartitionBackupInfo brokerVersion(String brokerVersion) {
    this.brokerVersion = brokerVersion;
    return this;
  }

  /**
   * The version of the broker from which the backup was taken for this partition.
   * @return brokerVersion
  */
  
  @Schema(name = "brokerVersion", accessMode = Schema.AccessMode.READ_ONLY, example = "8.1.2", description = "The version of the broker from which the backup was taken for this partition.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  public String getBrokerVersion() {
    return brokerVersion;
  }

  public void setBrokerVersion(String brokerVersion) {
    this.brokerVersion = brokerVersion;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PartitionBackupInfo partitionBackupInfo = (PartitionBackupInfo) o;
    return Objects.equals(this.partitionId, partitionBackupInfo.partitionId) &&
        Objects.equals(this.state, partitionBackupInfo.state) &&
        Objects.equals(this.failureReason, partitionBackupInfo.failureReason) &&
        Objects.equals(this.createdAt, partitionBackupInfo.createdAt) &&
        Objects.equals(this.lastUpdatedAt, partitionBackupInfo.lastUpdatedAt) &&
        Objects.equals(this.snapshotId, partitionBackupInfo.snapshotId) &&
        Objects.equals(this.checkpointPosition, partitionBackupInfo.checkpointPosition) &&
        Objects.equals(this.brokerId, partitionBackupInfo.brokerId) &&
        Objects.equals(this.brokerVersion, partitionBackupInfo.brokerVersion);
  }

  @Override
  public int hashCode() {
    return Objects.hash(partitionId, state, failureReason, createdAt, lastUpdatedAt, snapshotId, checkpointPosition, brokerId, brokerVersion);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PartitionBackupInfo {\n");
    sb.append("    partitionId: ").append(toIndentedString(partitionId)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    failureReason: ").append(toIndentedString(failureReason)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    lastUpdatedAt: ").append(toIndentedString(lastUpdatedAt)).append("\n");
    sb.append("    snapshotId: ").append(toIndentedString(snapshotId)).append("\n");
    sb.append("    checkpointPosition: ").append(toIndentedString(checkpointPosition)).append("\n");
    sb.append("    brokerId: ").append(toIndentedString(brokerId)).append("\n");
    sb.append("    brokerVersion: ").append(toIndentedString(brokerVersion)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

