/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.transport.stream.impl.messages;

import io.camunda.zeebe.transport.stream.impl.messages.MessageHeaderDecoder;
import io.camunda.zeebe.transport.stream.impl.messages.MessageHeaderEncoder;
import io.camunda.zeebe.transport.stream.impl.messages.PushStreamRequestDecoder;
import io.camunda.zeebe.transport.stream.impl.messages.PushStreamRequestEncoder;
import io.camunda.zeebe.util.SbeUtil;
import io.camunda.zeebe.util.buffer.BufferReader;
import io.camunda.zeebe.util.buffer.BufferWriter;
import io.camunda.zeebe.util.buffer.DirectBufferWriter;
import java.nio.ByteOrder;
import java.util.Objects;
import java.util.UUID;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.sbe.MessageEncoderFlyweight;

public final class PushStreamRequest
implements BufferReader,
BufferWriter {
    private final MessageHeaderEncoder headerEncoder = new MessageHeaderEncoder();
    private final MessageHeaderDecoder headerDecoder = new MessageHeaderDecoder();
    private final PushStreamRequestEncoder messageEncoder = new PushStreamRequestEncoder();
    private final PushStreamRequestDecoder messageDecoder = new PushStreamRequestDecoder();
    private final DirectBuffer payloadReader = new UnsafeBuffer();
    private BufferWriter payloadWriter = new DirectBufferWriter().wrap(this.payloadReader);
    private UUID streamId;

    public void wrap(DirectBuffer buffer, int offset, int length) {
        this.messageDecoder.wrapAndApplyHeader(buffer, 0, this.headerDecoder);
        this.streamId = new UUID(this.messageDecoder.id().high(), this.messageDecoder.id().low());
        this.messageDecoder.wrapPayload(this.payloadReader);
        this.payloadWriter = new DirectBufferWriter().wrap(this.payloadReader);
    }

    public int getLength() {
        return this.headerEncoder.encodedLength() + this.messageEncoder.sbeBlockLength() + PushStreamRequestEncoder.payloadHeaderLength() + this.payloadWriter.getLength();
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        this.messageEncoder.wrapAndApplyHeader(buffer, offset, this.headerEncoder);
        if (this.streamId != null) {
            this.messageEncoder.id().high(this.streamId.getMostSignificantBits()).low(this.streamId.getLeastSignificantBits());
        }
        SbeUtil.writeNested((BufferWriter)this.payloadWriter, (int)PushStreamRequestEncoder.payloadHeaderLength(), (MessageEncoderFlyweight)this.messageEncoder, (ByteOrder)PushStreamRequestEncoder.BYTE_ORDER);
    }

    public UUID streamId() {
        return this.streamId;
    }

    public PushStreamRequest streamId(UUID streamId) {
        this.streamId = streamId;
        return this;
    }

    public DirectBuffer payload() {
        return this.payloadReader;
    }

    public BufferWriter payloadWriter() {
        return this.payloadWriter;
    }

    public PushStreamRequest payload(BufferWriter payloadWriter) {
        this.payloadWriter = payloadWriter;
        this.payloadReader.wrap(0L, 0);
        return this;
    }

    public PushStreamRequest payload(DirectBuffer payload) {
        this.payloadReader.wrap(payload);
        this.payloadWriter = new DirectBufferWriter().wrap(payload);
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.streamId, this.payloadReader, this.payloadWriter);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PushStreamRequest that = (PushStreamRequest)o;
        return Objects.equals(this.streamId, that.streamId) && Objects.equals(this.payloadReader, that.payloadReader) && Objects.equals(this.payloadWriter, that.payloadWriter);
    }

    public String toString() {
        return "PushStreamRequest{streamId=" + this.streamId + "payload=byte['" + this.payloadWriter.getLength() + "]'}";
    }
}

