/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.identity.sdk.impl;

import io.camunda.identity.sdk.IdentityConfiguration;
import io.camunda.identity.sdk.authorizations.Authorizations;
import io.camunda.identity.sdk.authorizations.dto.Authorization;
import io.camunda.identity.sdk.impl.rest.RestClient;
import io.camunda.identity.sdk.impl.rest.request.AuthorizationRequest;
import io.camunda.identity.sdk.utility.UrlUtility;
import java.util.List;

public class AuthorizationsImpl
implements Authorizations {
    static final String AUTHORIZATIONS_PATH = "/api/authorizations";
    static final String FOR_TOKEN_PATH = "/for-token";
    private final String baseUrl;
    private final RestClient restClient;

    public AuthorizationsImpl(IdentityConfiguration identityConfiguration) {
        this(identityConfiguration.getBaseUrl());
    }

    private AuthorizationsImpl(String baseUrl) {
        this.baseUrl = baseUrl;
        this.restClient = new RestClient();
    }

    @Override
    public List<Authorization> forToken(String token) {
        return this.restClient.request(new AuthorizationRequest(UrlUtility.combinePaths(this.baseUrl, AUTHORIZATIONS_PATH, FOR_TOKEN_PATH), token));
    }
}

