/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.identity.sdk.impl.keycloak;

import io.camunda.identity.sdk.IdentityConfiguration;
import io.camunda.identity.sdk.authentication.AuthorizeUriBuilder;
import io.camunda.identity.sdk.utility.UrlQueryString;
import io.camunda.identity.sdk.utility.UrlUtility;
import java.net.URI;

class KeycloakAuthorizeUriBuilder
extends AuthorizeUriBuilder {
    private static final String DEFAULT_SCOPES = "openid email";
    private final String redirectUri;
    private final IdentityConfiguration configuration;

    KeycloakAuthorizeUriBuilder(IdentityConfiguration configuration, String redirectUri) {
        this.configuration = configuration;
        this.redirectUri = redirectUri;
    }

    @Override
    public URI build() {
        UrlQueryString query = new UrlQueryString().add("client_id", this.configuration.getClientId()).add("redirect_uri", this.redirectUri).add("response_type", "code").add("scope", DEFAULT_SCOPES);
        if (this.state != null) {
            query.add("state", this.state);
        }
        return URI.create(String.format("%s?%s", UrlUtility.combinePaths(this.configuration.getIssuer(), "/protocol/openid-connect/auth"), query.toString()));
    }
}

