/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.identity.sdk.impl.rest.request;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.HashMap;
import java.util.Map;

public abstract class Request<T> {
    final String url;
    final TypeReference<T> typeReference;
    String authentication;
    Map<String, String> params = new HashMap<String, String>();
    Object body;
    ContentType contentType = ContentType.X_WWW_URL_ENCODED;

    public Request(String url, TypeReference<T> typeReference) {
        this.url = url;
        this.typeReference = typeReference;
    }

    public String getUrl() {
        return this.url;
    }

    public String getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(String authentication) {
        this.authentication = authentication;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    public Object getBody() {
        return this.body;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public TypeReference<T> getTypeReference() {
        return this.typeReference;
    }

    public static enum ContentType {
        JSON("application/json"),
        X_WWW_URL_ENCODED("application/x-www-form-urlencoded");

        private final String value;

        private ContentType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

