/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.identity.sdk.impl.rest.request;

import com.fasterxml.jackson.core.type.TypeReference;
import io.camunda.identity.sdk.impl.rest.request.Request;
import io.camunda.identity.sdk.users.dto.User;
import io.camunda.identity.sdk.utility.UrlUtility;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UsersRequest
extends Request<List<User>> {
    public UsersRequest(String baseUrl, String authentication, List<String> userIds) {
        this(baseUrl, authentication, null, null, null, userIds);
    }

    public UsersRequest(String baseUrl, String authentication, String search, Integer page, Integer resultSize) {
        this(baseUrl, authentication, search, page, resultSize, null);
    }

    private UsersRequest(String baseUrl, String authentication, String search, Integer page, Integer resultSize, List<String> userIds) {
        super(UrlUtility.combinePaths(baseUrl, "/api/users"), new TypeReference<List<User>>(){});
        Map<String, String> params = this.buildParamMap(search, page, resultSize, userIds);
        this.setAuthentication(authentication);
        this.setParams(params);
    }

    private Map<String, String> buildParamMap(String search, Integer page, Integer resultSize, List<String> userIds) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (search != null) {
            params.put("search", search);
        }
        if (page != null) {
            params.put("page", String.valueOf(page));
        }
        if (resultSize != null) {
            params.put("resultSize", String.valueOf(resultSize));
        }
        if (userIds != null) {
            params.put("userIds", String.join((CharSequence)",", userIds));
        }
        return params;
    }
}

