/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.model.transformer;

import io.camunda.zeebe.engine.processing.deployment.model.element.AbstractFlowElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableActivity;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableBoundaryEvent;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableBusinessRuleTask;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCallActivity;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCatchEventElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableEndEvent;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableEventBasedGateway;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableExclusiveGateway;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableFlowElementContainer;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableFlowNode;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableInclusiveGateway;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableIntermediateThrowEvent;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableJobWorkerTask;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableProcess;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableReceiveTask;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableScriptTask;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableSequenceFlow;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableStartEvent;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.ModelElementTransformer;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.TransformContext;
import io.camunda.zeebe.model.bpmn.instance.Activity;
import io.camunda.zeebe.model.bpmn.instance.BoundaryEvent;
import io.camunda.zeebe.model.bpmn.instance.BusinessRuleTask;
import io.camunda.zeebe.model.bpmn.instance.CallActivity;
import io.camunda.zeebe.model.bpmn.instance.DataObject;
import io.camunda.zeebe.model.bpmn.instance.DataObjectReference;
import io.camunda.zeebe.model.bpmn.instance.DataStoreReference;
import io.camunda.zeebe.model.bpmn.instance.EndEvent;
import io.camunda.zeebe.model.bpmn.instance.EventBasedGateway;
import io.camunda.zeebe.model.bpmn.instance.ExclusiveGateway;
import io.camunda.zeebe.model.bpmn.instance.FlowElement;
import io.camunda.zeebe.model.bpmn.instance.InclusiveGateway;
import io.camunda.zeebe.model.bpmn.instance.IntermediateCatchEvent;
import io.camunda.zeebe.model.bpmn.instance.IntermediateThrowEvent;
import io.camunda.zeebe.model.bpmn.instance.ManualTask;
import io.camunda.zeebe.model.bpmn.instance.ParallelGateway;
import io.camunda.zeebe.model.bpmn.instance.ReceiveTask;
import io.camunda.zeebe.model.bpmn.instance.ScriptTask;
import io.camunda.zeebe.model.bpmn.instance.SendTask;
import io.camunda.zeebe.model.bpmn.instance.SequenceFlow;
import io.camunda.zeebe.model.bpmn.instance.ServiceTask;
import io.camunda.zeebe.model.bpmn.instance.StartEvent;
import io.camunda.zeebe.model.bpmn.instance.SubProcess;
import io.camunda.zeebe.model.bpmn.instance.Task;
import io.camunda.zeebe.model.bpmn.instance.UserTask;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public final class FlowElementInstantiationTransformer
implements ModelElementTransformer<FlowElement> {
    private static final Map<Class<?>, Function<String, AbstractFlowElement>> ELEMENT_FACTORIES;
    private static final Set<Class<?>> NON_EXECUTABLE_ELEMENT_TYPES;

    @Override
    public Class<FlowElement> getType() {
        return FlowElement.class;
    }

    @Override
    public void transform(FlowElement element, TransformContext context) {
        ExecutableProcess process = context.getCurrentProcess();
        Class elementType = element.getElementType().getInstanceType();
        if (!NON_EXECUTABLE_ELEMENT_TYPES.contains(elementType)) {
            Function<String, AbstractFlowElement> elementFactory = ELEMENT_FACTORIES.get(elementType);
            if (elementFactory == null) {
                throw new IllegalStateException("no transformer found for element type: " + elementType);
            }
            AbstractFlowElement executableElement = elementFactory.apply(element.getId());
            executableElement.setElementType(BpmnElementType.bpmnElementTypeFor((String)element.getElementType().getTypeName()));
            process.addFlowElement(executableElement);
        }
    }

    static {
        NON_EXECUTABLE_ELEMENT_TYPES = new HashSet();
        ELEMENT_FACTORIES = new HashMap();
        ELEMENT_FACTORIES.put(Activity.class, ExecutableActivity::new);
        ELEMENT_FACTORIES.put(BusinessRuleTask.class, ExecutableBusinessRuleTask::new);
        ELEMENT_FACTORIES.put(BoundaryEvent.class, ExecutableBoundaryEvent::new);
        ELEMENT_FACTORIES.put(CallActivity.class, ExecutableCallActivity::new);
        ELEMENT_FACTORIES.put(EndEvent.class, ExecutableEndEvent::new);
        ELEMENT_FACTORIES.put(EventBasedGateway.class, ExecutableEventBasedGateway::new);
        ELEMENT_FACTORIES.put(ExclusiveGateway.class, ExecutableExclusiveGateway::new);
        ELEMENT_FACTORIES.put(InclusiveGateway.class, ExecutableInclusiveGateway::new);
        ELEMENT_FACTORIES.put(IntermediateCatchEvent.class, ExecutableCatchEventElement::new);
        ELEMENT_FACTORIES.put(IntermediateThrowEvent.class, ExecutableIntermediateThrowEvent::new);
        ELEMENT_FACTORIES.put(ManualTask.class, ExecutableActivity::new);
        ELEMENT_FACTORIES.put(Task.class, ExecutableActivity::new);
        ELEMENT_FACTORIES.put(ParallelGateway.class, ExecutableFlowNode::new);
        ELEMENT_FACTORIES.put(ReceiveTask.class, ExecutableReceiveTask::new);
        ELEMENT_FACTORIES.put(ScriptTask.class, ExecutableScriptTask::new);
        ELEMENT_FACTORIES.put(SendTask.class, ExecutableJobWorkerTask::new);
        ELEMENT_FACTORIES.put(SequenceFlow.class, ExecutableSequenceFlow::new);
        ELEMENT_FACTORIES.put(ServiceTask.class, ExecutableJobWorkerTask::new);
        ELEMENT_FACTORIES.put(StartEvent.class, ExecutableStartEvent::new);
        ELEMENT_FACTORIES.put(SubProcess.class, ExecutableFlowElementContainer::new);
        ELEMENT_FACTORIES.put(UserTask.class, ExecutableJobWorkerTask::new);
        NON_EXECUTABLE_ELEMENT_TYPES.add(DataObject.class);
        NON_EXECUTABLE_ELEMENT_TYPES.add(DataObjectReference.class);
        NON_EXECUTABLE_ELEMENT_TYPES.add(DataStoreReference.class);
    }
}

