/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.incident;

import io.camunda.zeebe.engine.processing.incident.IncidentRecordWrapper;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedRejectionWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedResponseWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.immutable.ElementInstanceState;
import io.camunda.zeebe.engine.state.immutable.IncidentState;
import io.camunda.zeebe.engine.state.immutable.ProcessingState;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.protocol.impl.record.value.incident.IncidentRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.stream.api.records.TypedRecord;
import io.camunda.zeebe.util.Either;

public final class ResolveIncidentProcessor
implements TypedRecordProcessor<IncidentRecord> {
    public static final String NO_INCIDENT_FOUND_MSG = "Expected to resolve incident with key '%d', but no such incident was found";
    private static final String ELEMENT_NOT_IN_SUPPORTED_STATE_MSG = "Expected incident to refer to element in state ELEMENT_ACTIVATING or ELEMENT_COMPLETING, but element is in state %s";
    private final ProcessInstanceRecord failedRecord = new ProcessInstanceRecord();
    private final TypedRecordProcessor<ProcessInstanceRecord> bpmnStreamProcessor;
    private final StateWriter stateWriter;
    private final TypedRejectionWriter rejectionWriter;
    private final IncidentState incidentState;
    private final ElementInstanceState elementInstanceState;
    private final TypedResponseWriter responseWriter;

    public ResolveIncidentProcessor(ProcessingState processingState, TypedRecordProcessor<ProcessInstanceRecord> bpmnStreamProcessor, Writers writers) {
        this.bpmnStreamProcessor = bpmnStreamProcessor;
        this.stateWriter = writers.state();
        this.rejectionWriter = writers.rejection();
        this.responseWriter = writers.response();
        this.incidentState = processingState.getIncidentState();
        this.elementInstanceState = processingState.getElementInstanceState();
    }

    @Override
    public void processRecord(TypedRecord<IncidentRecord> command) {
        long key = command.getKey();
        IncidentRecord incident = this.incidentState.getIncidentRecord(key);
        if (incident == null) {
            String errorMessage = String.format(NO_INCIDENT_FOUND_MSG, key);
            this.rejectResolveCommand(command, errorMessage, RejectionType.NOT_FOUND);
            return;
        }
        this.stateWriter.appendFollowUpEvent(key, (Intent)IncidentIntent.RESOLVED, (RecordValue)incident);
        this.responseWriter.writeEventOnCommand(key, (Intent)IncidentIntent.RESOLVED, (UnpackedObject)incident, command);
        this.attemptToContinueProcessProcessing(command, incident);
    }

    private void rejectResolveCommand(TypedRecord<IncidentRecord> command, String errorMessage, RejectionType rejectionType) {
        this.rejectionWriter.appendRejection(command, rejectionType, errorMessage);
        this.responseWriter.writeRejectionOnCommand(command, RejectionType.NOT_FOUND, errorMessage);
    }

    private void attemptToContinueProcessProcessing(TypedRecord<IncidentRecord> command, IncidentRecord incident) {
        boolean isJobIncident;
        long jobKey = incident.getJobKey();
        boolean bl = isJobIncident = jobKey > 0L;
        if (isJobIncident) {
            return;
        }
        this.getFailedCommand(incident).ifRightOrLeft(failedCommand -> this.bpmnStreamProcessor.processRecord((TypedRecord<ProcessInstanceRecord>)failedCommand), failure -> {
            String message = String.format("Expected to continue processing after incident %d resolved, but failed command not found", command.getKey());
            throw new IllegalStateException(message, new IllegalStateException((String)failure));
        });
    }

    private Either<String, TypedRecord<ProcessInstanceRecord>> getFailedCommand(IncidentRecord incidentRecord) {
        long elementInstanceKey = incidentRecord.getElementInstanceKey();
        ElementInstance elementInstance = this.elementInstanceState.getInstance(elementInstanceKey);
        if (elementInstance == null) {
            return Either.left((Object)String.format("Expected to find failed command for element instance %d, but element instance not found", elementInstanceKey));
        }
        return this.getFailedCommandIntent(elementInstance).map(commandIntent -> {
            this.failedRecord.wrap(elementInstance.getValue());
            return new IncidentRecordWrapper(elementInstanceKey, (ProcessInstanceIntent)commandIntent, this.failedRecord);
        });
    }

    private Either<String, ProcessInstanceIntent> getFailedCommandIntent(ElementInstance elementInstance) {
        ProcessInstanceIntent instanceState = elementInstance.getState();
        switch (instanceState) {
            case ELEMENT_ACTIVATING: {
                return Either.right((Object)ProcessInstanceIntent.ACTIVATE_ELEMENT);
            }
            case ELEMENT_COMPLETING: {
                return Either.right((Object)ProcessInstanceIntent.COMPLETE_ELEMENT);
            }
        }
        return Either.left((Object)String.format(ELEMENT_NOT_IN_SUPPORTED_STATE_MSG, instanceState));
    }
}

