/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.deployment;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbForeignKey;
import io.camunda.zeebe.db.impl.DbInt;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbNil;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.engine.state.deployment.PersistedDecision;
import io.camunda.zeebe.engine.state.deployment.PersistedDecisionRequirements;
import io.camunda.zeebe.engine.state.mutable.MutableDecisionState;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DecisionRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DecisionRequirementsRecord;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.agrona.DirectBuffer;

public final class DbDecisionState
implements MutableDecisionState {
    private final DbLong dbDecisionKey = new DbLong();
    private final DbForeignKey<DbLong> fkDecision = new DbForeignKey((DbKey)this.dbDecisionKey, (Enum)ZbColumnFamilies.DMN_DECISIONS);
    private final PersistedDecision dbPersistedDecision = new PersistedDecision();
    private final DbString dbDecisionId;
    private final DbLong dbDecisionRequirementsKey;
    private final DbForeignKey<DbLong> fkDecisionRequirements;
    private final PersistedDecisionRequirements dbPersistedDecisionRequirements;
    private final DbString dbDecisionRequirementsId;
    private final DbCompositeKey<DbForeignKey<DbLong>, DbForeignKey<DbLong>> dbDecisionRequirementsKeyAndDecisionKey;
    private final ColumnFamily<DbCompositeKey<DbForeignKey<DbLong>, DbForeignKey<DbLong>>, DbNil> decisionKeyByDecisionRequirementsKey;
    private final ColumnFamily<DbLong, PersistedDecision> decisionsByKey;
    private final ColumnFamily<DbString, DbForeignKey<DbLong>> latestDecisionKeysByDecisionId;
    private final DbInt dbDecisionVersion;
    private final DbCompositeKey<DbString, DbInt> decisionIdAndVersion;
    private final ColumnFamily<DbCompositeKey<DbString, DbInt>, DbForeignKey<DbLong>> decisionKeyByDecisionIdAndVersion;
    private final ColumnFamily<DbLong, PersistedDecisionRequirements> decisionRequirementsByKey;
    private final ColumnFamily<DbString, DbForeignKey<DbLong>> latestDecisionRequirementsKeysById;
    private final DbInt dbDecisionRequirementsVersion;
    private final DbCompositeKey<DbString, DbInt> decisionRequirementsIdAndVersion;
    private final ColumnFamily<DbCompositeKey<DbString, DbInt>, DbForeignKey<DbLong>> decisionRequirementsKeyByIdAndVersion;

    public DbDecisionState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.decisionsByKey = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.DMN_DECISIONS, transactionContext, (DbKey)this.dbDecisionKey, (DbValue)this.dbPersistedDecision);
        this.dbDecisionId = new DbString();
        this.latestDecisionKeysByDecisionId = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.DMN_LATEST_DECISION_BY_ID, transactionContext, (DbKey)this.dbDecisionId, this.fkDecision);
        this.dbDecisionRequirementsKey = new DbLong();
        this.fkDecisionRequirements = new DbForeignKey((DbKey)this.dbDecisionRequirementsKey, (Enum)ZbColumnFamilies.DMN_DECISION_REQUIREMENTS);
        this.dbPersistedDecisionRequirements = new PersistedDecisionRequirements();
        this.decisionRequirementsByKey = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.DMN_DECISION_REQUIREMENTS, transactionContext, (DbKey)this.dbDecisionRequirementsKey, (DbValue)this.dbPersistedDecisionRequirements);
        this.dbDecisionRequirementsId = new DbString();
        this.latestDecisionRequirementsKeysById = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.DMN_LATEST_DECISION_REQUIREMENTS_BY_ID, transactionContext, (DbKey)this.dbDecisionRequirementsId, this.fkDecisionRequirements);
        this.dbDecisionRequirementsKeyAndDecisionKey = new DbCompositeKey(this.fkDecisionRequirements, this.fkDecision);
        this.decisionKeyByDecisionRequirementsKey = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.DMN_DECISION_KEY_BY_DECISION_REQUIREMENTS_KEY, transactionContext, this.dbDecisionRequirementsKeyAndDecisionKey, (DbValue)DbNil.INSTANCE);
        this.dbDecisionVersion = new DbInt();
        this.decisionIdAndVersion = new DbCompositeKey((DbKey)this.dbDecisionId, (DbKey)this.dbDecisionVersion);
        this.decisionKeyByDecisionIdAndVersion = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.DMN_DECISION_KEY_BY_DECISION_ID_AND_VERSION, transactionContext, this.decisionIdAndVersion, this.fkDecision);
        this.dbDecisionRequirementsVersion = new DbInt();
        this.decisionRequirementsIdAndVersion = new DbCompositeKey((DbKey)this.dbDecisionRequirementsId, (DbKey)this.dbDecisionRequirementsVersion);
        this.decisionRequirementsKeyByIdAndVersion = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.DMN_DECISION_REQUIREMENTS_KEY_BY_DECISION_REQUIREMENT_ID_AND_VERSION, transactionContext, this.decisionRequirementsIdAndVersion, this.fkDecisionRequirements);
    }

    @Override
    public Optional<PersistedDecision> findLatestDecisionById(DirectBuffer decisionId) {
        this.dbDecisionId.wrapBuffer(decisionId);
        return Optional.ofNullable((DbForeignKey)this.latestDecisionKeysByDecisionId.get((DbKey)this.dbDecisionId)).flatMap(decisionKey -> this.findDecisionByKey(((DbLong)decisionKey.inner()).getValue()));
    }

    @Override
    public Optional<PersistedDecision> findDecisionByKey(long decisionKey) {
        this.dbDecisionKey.wrapLong(decisionKey);
        return Optional.ofNullable((PersistedDecision)this.decisionsByKey.get((DbKey)this.dbDecisionKey)).map(PersistedDecision::copy);
    }

    @Override
    public Optional<PersistedDecisionRequirements> findLatestDecisionRequirementsById(DirectBuffer decisionRequirementsId) {
        this.dbDecisionRequirementsId.wrapBuffer(decisionRequirementsId);
        return Optional.ofNullable((DbForeignKey)this.latestDecisionRequirementsKeysById.get((DbKey)this.dbDecisionRequirementsId)).map(requirementsKey -> ((DbLong)requirementsKey.inner()).getValue()).flatMap(this::findDecisionRequirementsByKey);
    }

    @Override
    public Optional<PersistedDecisionRequirements> findDecisionRequirementsByKey(long decisionRequirementsKey) {
        this.dbDecisionRequirementsKey.wrapLong(decisionRequirementsKey);
        return Optional.ofNullable((PersistedDecisionRequirements)this.decisionRequirementsByKey.get((DbKey)this.dbDecisionRequirementsKey)).map(PersistedDecisionRequirements::copy);
    }

    @Override
    public List<PersistedDecision> findDecisionsByDecisionRequirementsKey(long decisionRequirementsKey) {
        ArrayList<PersistedDecision> decisions = new ArrayList<PersistedDecision>();
        this.dbDecisionRequirementsKey.wrapLong(decisionRequirementsKey);
        this.decisionKeyByDecisionRequirementsKey.whileEqualPrefix((DbKey)this.dbDecisionRequirementsKey, (key, nil) -> {
            DbForeignKey decisionKey = (DbForeignKey)key.second();
            this.findDecisionByKey(((DbLong)decisionKey.inner()).getValue()).ifPresent(decisions::add);
        });
        return decisions;
    }

    private Optional<Long> findPreviousVersionDecisionKey(DirectBuffer decisionId, int currentVersion) {
        HashMap decisionKeysByVersion = new HashMap();
        this.dbDecisionId.wrapBuffer(decisionId);
        this.decisionKeyByDecisionIdAndVersion.whileEqualPrefix((DbKey)this.dbDecisionId, (key, decisionKey) -> {
            if (((DbInt)key.second()).getValue() < currentVersion) {
                decisionKeysByVersion.put(((DbInt)key.second()).getValue(), ((DbLong)decisionKey.inner()).getValue());
            }
        });
        if (decisionKeysByVersion.isEmpty()) {
            return Optional.empty();
        }
        Integer previousVersion = (Integer)Collections.max(decisionKeysByVersion.keySet());
        return Optional.of((Long)decisionKeysByVersion.get(previousVersion));
    }

    private Optional<Long> findPreviousVersionDecisionRequirementsKey(DirectBuffer decisionRequirementsId, int currentVersion) {
        HashMap decisionRequirementsKeysByVersion = new HashMap();
        this.dbDecisionRequirementsId.wrapBuffer(decisionRequirementsId);
        this.decisionRequirementsKeyByIdAndVersion.whileEqualPrefix((DbKey)this.dbDecisionRequirementsId, (key, drgKey) -> {
            if (((DbInt)key.second()).getValue() < currentVersion) {
                decisionRequirementsKeysByVersion.put(((DbInt)key.second()).getValue(), ((DbLong)drgKey.inner()).getValue());
            }
        });
        if (decisionRequirementsKeysByVersion.isEmpty()) {
            return Optional.empty();
        }
        Integer previousVersion = (Integer)Collections.max(decisionRequirementsKeysByVersion.keySet());
        return Optional.of((Long)decisionRequirementsKeysByVersion.get(previousVersion));
    }

    @Override
    public void storeDecisionRecord(DecisionRecord record) {
        this.dbDecisionKey.wrapLong(record.getDecisionKey());
        this.dbPersistedDecision.wrap(record);
        this.decisionsByKey.upsert((DbKey)this.dbDecisionKey, (DbValue)this.dbPersistedDecision);
        this.dbDecisionKey.wrapLong(record.getDecisionKey());
        this.dbDecisionRequirementsKey.wrapLong(record.getDecisionRequirementsKey());
        this.decisionKeyByDecisionRequirementsKey.upsert(this.dbDecisionRequirementsKeyAndDecisionKey, (DbValue)DbNil.INSTANCE);
        this.dbDecisionId.wrapString(record.getDecisionId());
        this.dbDecisionVersion.wrapInt(record.getVersion());
        this.decisionKeyByDecisionIdAndVersion.upsert(this.decisionIdAndVersion, this.fkDecision);
        this.updateLatestDecisionVersion(record);
    }

    @Override
    public void storeDecisionRequirements(DecisionRequirementsRecord record) {
        this.dbDecisionRequirementsKey.wrapLong(record.getDecisionRequirementsKey());
        this.dbPersistedDecisionRequirements.wrap(record);
        this.decisionRequirementsByKey.upsert((DbKey)this.dbDecisionRequirementsKey, (DbValue)this.dbPersistedDecisionRequirements);
        this.dbDecisionRequirementsId.wrapString(record.getDecisionRequirementsId());
        this.dbDecisionRequirementsVersion.wrapInt(record.getDecisionRequirementsVersion());
        this.decisionRequirementsKeyByIdAndVersion.upsert(this.decisionRequirementsIdAndVersion, this.fkDecisionRequirements);
        this.updateLatestDecisionRequirementsVersion(record);
    }

    @Override
    public void deleteDecision(DecisionRecord record) {
        this.findLatestDecisionById(record.getDecisionIdBuffer()).map(PersistedDecision::getVersion).ifPresent(latestVersion -> {
            if (latestVersion.intValue() == record.getVersion()) {
                this.dbDecisionId.wrapBuffer(record.getDecisionIdBuffer());
                this.findPreviousVersionDecisionKey(record.getDecisionIdBuffer(), record.getVersion()).ifPresentOrElse(previousDecisionKey -> {
                    this.dbDecisionKey.wrapLong(previousDecisionKey.longValue());
                    this.latestDecisionKeysByDecisionId.update((DbKey)this.dbDecisionId, this.fkDecision);
                }, () -> this.latestDecisionKeysByDecisionId.deleteExisting((DbKey)this.dbDecisionId));
            }
        });
        this.dbDecisionRequirementsKey.wrapLong(record.getDecisionRequirementsKey());
        this.dbDecisionKey.wrapLong(record.getDecisionKey());
        this.dbDecisionId.wrapBuffer(record.getDecisionIdBuffer());
        this.dbDecisionVersion.wrapInt(record.getVersion());
        this.decisionKeyByDecisionRequirementsKey.deleteExisting(this.dbDecisionRequirementsKeyAndDecisionKey);
        this.decisionsByKey.deleteExisting((DbKey)this.dbDecisionKey);
        this.decisionKeyByDecisionIdAndVersion.deleteExisting(this.decisionIdAndVersion);
    }

    @Override
    public void deleteDecisionRequirements(DecisionRequirementsRecord record) {
        this.findLatestDecisionRequirementsById(record.getDecisionRequirementsIdBuffer()).map(PersistedDecisionRequirements::getDecisionRequirementsVersion).ifPresent(latestVersion -> {
            if (latestVersion.intValue() == record.getDecisionRequirementsVersion()) {
                this.dbDecisionRequirementsId.wrapBuffer(record.getDecisionRequirementsIdBuffer());
                this.findPreviousVersionDecisionRequirementsKey(record.getDecisionRequirementsIdBuffer(), record.getDecisionRequirementsVersion()).ifPresentOrElse(previousDrgKey -> {
                    this.dbDecisionRequirementsKey.wrapLong(previousDrgKey.longValue());
                    this.latestDecisionRequirementsKeysById.update((DbKey)this.dbDecisionRequirementsId, this.fkDecisionRequirements);
                }, () -> this.latestDecisionRequirementsKeysById.deleteExisting((DbKey)this.dbDecisionRequirementsId));
            }
        });
        this.dbDecisionRequirementsKey.wrapLong(record.getDecisionRequirementsKey());
        this.dbDecisionRequirementsId.wrapBuffer(record.getDecisionRequirementsIdBuffer());
        this.dbDecisionRequirementsVersion.wrapInt(record.getDecisionRequirementsVersion());
        this.decisionRequirementsByKey.deleteExisting((DbKey)this.dbDecisionRequirementsKey);
        this.decisionRequirementsKeyByIdAndVersion.deleteExisting(this.decisionRequirementsIdAndVersion);
    }

    private void updateLatestDecisionVersion(DecisionRecord record) {
        this.findLatestDecisionById(record.getDecisionIdBuffer()).ifPresentOrElse(previousVersion -> {
            if (record.getVersion() > previousVersion.getVersion()) {
                this.updateDecisionAsLatestVersion(record);
            }
        }, () -> this.insertDecisionAsLatestVersion(record));
    }

    private void updateDecisionAsLatestVersion(DecisionRecord record) {
        this.dbDecisionId.wrapBuffer(record.getDecisionIdBuffer());
        this.dbDecisionKey.wrapLong(record.getDecisionKey());
        this.latestDecisionKeysByDecisionId.update((DbKey)this.dbDecisionId, this.fkDecision);
    }

    private void insertDecisionAsLatestVersion(DecisionRecord record) {
        this.dbDecisionId.wrapBuffer(record.getDecisionIdBuffer());
        this.dbDecisionKey.wrapLong(record.getDecisionKey());
        this.latestDecisionKeysByDecisionId.upsert((DbKey)this.dbDecisionId, this.fkDecision);
    }

    private void updateLatestDecisionRequirementsVersion(DecisionRequirementsRecord record) {
        this.findLatestDecisionRequirementsById(record.getDecisionRequirementsIdBuffer()).ifPresentOrElse(previousVersion -> {
            if (record.getDecisionRequirementsVersion() > previousVersion.getDecisionRequirementsVersion()) {
                this.updateDecisionRequirementsAsLatestVersion(record);
            }
        }, () -> this.insertDecisionRequirementsAsLatestVersion(record));
    }

    private void updateDecisionRequirementsAsLatestVersion(DecisionRequirementsRecord record) {
        this.dbDecisionRequirementsId.wrapBuffer(record.getDecisionRequirementsIdBuffer());
        this.dbDecisionRequirementsKey.wrapLong(record.getDecisionRequirementsKey());
        this.latestDecisionRequirementsKeysById.update((DbKey)this.dbDecisionRequirementsId, this.fkDecisionRequirements);
    }

    private void insertDecisionRequirementsAsLatestVersion(DecisionRequirementsRecord record) {
        this.dbDecisionRequirementsId.wrapBuffer(record.getDecisionRequirementsIdBuffer());
        this.dbDecisionRequirementsKey.wrapLong(record.getDecisionRequirementsKey());
        this.latestDecisionRequirementsKeysById.upsert((DbKey)this.dbDecisionRequirementsId, this.fkDecisionRequirements);
    }
}

