/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.instance;

import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.msgpack.property.BaseProperty;
import io.camunda.zeebe.msgpack.property.BinaryProperty;
import io.camunda.zeebe.msgpack.property.LongProperty;
import io.camunda.zeebe.msgpack.property.StringProperty;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.Objects;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class EventTrigger
extends UnpackedObject
implements DbValue {
    private final StringProperty elementIdProp = new StringProperty("elementId");
    private final BinaryProperty variablesProp = new BinaryProperty("variables");
    private final LongProperty eventKeyProp = new LongProperty("eventKey");
    private final LongProperty processInstanceKeyProp = new LongProperty("processInstanceKey", -1L);

    public EventTrigger() {
        this.declareProperty((BaseProperty)this.elementIdProp).declareProperty((BaseProperty)this.variablesProp).declareProperty((BaseProperty)this.eventKeyProp).declareProperty((BaseProperty)this.processInstanceKeyProp);
    }

    public EventTrigger(EventTrigger other) {
        this();
        int length = other.getLength();
        UnsafeBuffer buffer = new UnsafeBuffer(new byte[length]);
        other.write((MutableDirectBuffer)buffer, 0);
        this.wrap((DirectBuffer)buffer, 0, length);
    }

    public DirectBuffer getElementId() {
        return this.elementIdProp.getValue();
    }

    public EventTrigger setElementId(DirectBuffer elementId) {
        this.elementIdProp.setValue(elementId);
        return this;
    }

    public DirectBuffer getVariables() {
        return this.variablesProp.getValue();
    }

    public EventTrigger setVariables(DirectBuffer variables) {
        this.variablesProp.setValue(variables);
        return this;
    }

    public long getEventKey() {
        return this.eventKeyProp.getValue();
    }

    public EventTrigger setEventKey(long eventKey) {
        this.eventKeyProp.setValue(eventKey);
        return this;
    }

    public long getProcessInstanceKey() {
        return this.processInstanceKeyProp.getValue();
    }

    public EventTrigger setProcessInstanceKey(long processInstanceKey) {
        this.processInstanceKeyProp.setValue(processInstanceKey);
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.getElementId(), this.getVariables());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        EventTrigger that = (EventTrigger)((Object)o);
        return BufferUtil.equals((DirectBuffer)this.getElementId(), (DirectBuffer)that.getElementId()) && BufferUtil.equals((DirectBuffer)this.getVariables(), (DirectBuffer)that.getVariables());
    }
}

