/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.record.value.decision;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.camunda.zeebe.msgpack.property.ArrayProperty;
import io.camunda.zeebe.msgpack.property.BaseProperty;
import io.camunda.zeebe.msgpack.property.BinaryProperty;
import io.camunda.zeebe.msgpack.property.IntegerProperty;
import io.camunda.zeebe.msgpack.property.LongProperty;
import io.camunda.zeebe.msgpack.property.StringProperty;
import io.camunda.zeebe.msgpack.value.BaseValue;
import io.camunda.zeebe.msgpack.value.ValueArray;
import io.camunda.zeebe.protocol.impl.encoding.MsgPackConverter;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.impl.record.value.decision.EvaluatedInputRecord;
import io.camunda.zeebe.protocol.impl.record.value.decision.MatchedRuleRecord;
import io.camunda.zeebe.protocol.record.value.EvaluatedDecisionValue;
import io.camunda.zeebe.protocol.record.value.EvaluatedInputValue;
import io.camunda.zeebe.protocol.record.value.MatchedRuleValue;
import io.camunda.zeebe.util.buffer.BufferUtil;
import io.camunda.zeebe.util.buffer.BufferWriter;
import java.util.ArrayList;
import java.util.List;
import org.agrona.DirectBuffer;

public final class EvaluatedDecisionRecord
extends UnifiedRecordValue
implements EvaluatedDecisionValue {
    private final StringProperty decisionIdProp = new StringProperty("decisionId");
    private final StringProperty decisionNameProp = new StringProperty("decisionName");
    private final LongProperty decisionKeyProp = new LongProperty("decisionKey");
    private final IntegerProperty decisionVersionProp = new IntegerProperty("decisionVersion");
    private final StringProperty decisionTypeProp = new StringProperty("decisionType");
    private final BinaryProperty decisionOutputProp = new BinaryProperty("decisionOutput");
    private final ArrayProperty<EvaluatedInputRecord> evaluatedInputsProp = new ArrayProperty("evaluatedInputs", (BaseValue)new EvaluatedInputRecord());
    private final ArrayProperty<MatchedRuleRecord> matchedRulesProp = new ArrayProperty("matchedRules", (BaseValue)new MatchedRuleRecord());

    public EvaluatedDecisionRecord() {
        this.declareProperty((BaseProperty)this.decisionIdProp).declareProperty((BaseProperty)this.decisionNameProp).declareProperty((BaseProperty)this.decisionKeyProp).declareProperty((BaseProperty)this.decisionVersionProp).declareProperty((BaseProperty)this.decisionTypeProp).declareProperty((BaseProperty)this.decisionOutputProp).declareProperty(this.evaluatedInputsProp).declareProperty(this.matchedRulesProp);
    }

    public String getDecisionId() {
        return BufferUtil.bufferAsString((DirectBuffer)this.decisionIdProp.getValue());
    }

    public EvaluatedDecisionRecord setDecisionId(String decisionId) {
        this.decisionIdProp.setValue(decisionId);
        return this;
    }

    public String getDecisionName() {
        return BufferUtil.bufferAsString((DirectBuffer)this.decisionNameProp.getValue());
    }

    public EvaluatedDecisionRecord setDecisionName(String decisionName) {
        this.decisionNameProp.setValue(decisionName);
        return this;
    }

    public long getDecisionKey() {
        return this.decisionKeyProp.getValue();
    }

    public EvaluatedDecisionRecord setDecisionKey(long decisionKey) {
        this.decisionKeyProp.setValue(decisionKey);
        return this;
    }

    public int getDecisionVersion() {
        return this.decisionVersionProp.getValue();
    }

    public EvaluatedDecisionRecord setDecisionVersion(int decisionVersion) {
        this.decisionVersionProp.setValue(decisionVersion);
        return this;
    }

    public String getDecisionType() {
        return BufferUtil.bufferAsString((DirectBuffer)this.decisionTypeProp.getValue());
    }

    public EvaluatedDecisionRecord setDecisionType(String decisionType) {
        this.decisionTypeProp.setValue(decisionType);
        return this;
    }

    public String getDecisionOutput() {
        return MsgPackConverter.convertToJson(this.decisionOutputProp.getValue());
    }

    public EvaluatedDecisionRecord setDecisionOutput(DirectBuffer decisionOutput) {
        this.decisionOutputProp.setValue(decisionOutput);
        return this;
    }

    public List<EvaluatedInputValue> getEvaluatedInputs() {
        ArrayList<EvaluatedInputValue> evaluatedInputs = new ArrayList<EvaluatedInputValue>();
        for (EvaluatedInputRecord evaluatedInput : this.evaluatedInputsProp) {
            EvaluatedInputRecord copyRecord = new EvaluatedInputRecord();
            DirectBuffer copyBuffer = BufferUtil.createCopy((BufferWriter)evaluatedInput);
            copyRecord.wrap(copyBuffer);
            evaluatedInputs.add(copyRecord);
        }
        return evaluatedInputs;
    }

    public List<MatchedRuleValue> getMatchedRules() {
        ArrayList<MatchedRuleValue> matchedRules = new ArrayList<MatchedRuleValue>();
        for (MatchedRuleRecord matchedRule : this.matchedRulesProp) {
            MatchedRuleRecord copyRecord = new MatchedRuleRecord();
            DirectBuffer copyBuffer = BufferUtil.createCopy((BufferWriter)matchedRule);
            copyRecord.wrap(copyBuffer);
            matchedRules.add(copyRecord);
        }
        return matchedRules;
    }

    @JsonIgnore
    public DirectBuffer getDecisionOutputBuffer() {
        return this.decisionOutputProp.getValue();
    }

    @JsonIgnore
    public ValueArray<MatchedRuleRecord> matchedRules() {
        return this.matchedRulesProp;
    }

    @JsonIgnore
    public ValueArray<EvaluatedInputRecord> evaluatedInputs() {
        return this.evaluatedInputsProp;
    }

    @JsonIgnore
    public DirectBuffer getDecisionIdBuffer() {
        return this.decisionIdProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getDecisionNameBuffer() {
        return this.decisionNameProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getDecisionTypeBuffer() {
        return this.decisionTypeProp.getValue();
    }
}

