/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.record.value.processinstance;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.camunda.zeebe.msgpack.property.BaseProperty;
import io.camunda.zeebe.msgpack.property.EnumProperty;
import io.camunda.zeebe.msgpack.property.IntegerProperty;
import io.camunda.zeebe.msgpack.property.LongProperty;
import io.camunda.zeebe.msgpack.property.StringProperty;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.BpmnEventType;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;

public final class ProcessInstanceRecord
extends UnifiedRecordValue
implements ProcessInstanceRecordValue {
    public static final String PROP_PROCESS_BPMN_PROCESS_ID = "bpmnProcessId";
    public static final String PROP_PROCESS_INSTANCE_KEY = "processInstanceKey";
    public static final String PROP_PROCESS_ELEMENT_ID = "elementId";
    public static final String PROP_PROCESS_VERSION = "version";
    public static final String PROP_PROCESS_KEY = "processDefinitionKey";
    public static final String PROP_PROCESS_BPMN_TYPE = "bpmnElementType";
    public static final String PROP_PROCESS_SCOPE_KEY = "flowScopeKey";
    public static final String PROP_PROCESS_EVENT_TYPE = "bpmnEventType";
    private final StringProperty bpmnProcessIdProp = new StringProperty("bpmnProcessId", "");
    private final IntegerProperty versionProp = new IntegerProperty("version", -1);
    private final LongProperty processDefinitionKeyProp = new LongProperty("processDefinitionKey", -1L);
    private final LongProperty processInstanceKeyProp = new LongProperty("processInstanceKey", -1L);
    private final StringProperty elementIdProp = new StringProperty("elementId", "");
    private final LongProperty flowScopeKeyProp = new LongProperty("flowScopeKey", -1L);
    private final EnumProperty<BpmnElementType> bpmnElementTypeProp = new EnumProperty("bpmnElementType", BpmnElementType.class, (Enum)BpmnElementType.UNSPECIFIED);
    private final EnumProperty<BpmnEventType> bpmnEventTypeProp = new EnumProperty("bpmnEventType", BpmnEventType.class, (Enum)BpmnEventType.UNSPECIFIED);
    private final LongProperty parentProcessInstanceKeyProp = new LongProperty("parentProcessInstanceKey", -1L);
    private final LongProperty parentElementInstanceKeyProp = new LongProperty("parentElementInstanceKey", -1L);

    public ProcessInstanceRecord() {
        this.declareProperty((BaseProperty)this.bpmnElementTypeProp).declareProperty((BaseProperty)this.elementIdProp).declareProperty((BaseProperty)this.bpmnProcessIdProp).declareProperty((BaseProperty)this.versionProp).declareProperty((BaseProperty)this.processDefinitionKeyProp).declareProperty((BaseProperty)this.processInstanceKeyProp).declareProperty((BaseProperty)this.flowScopeKeyProp).declareProperty(this.bpmnEventTypeProp).declareProperty((BaseProperty)this.parentProcessInstanceKeyProp).declareProperty((BaseProperty)this.parentElementInstanceKeyProp);
    }

    public void wrap(ProcessInstanceRecord record) {
        this.elementIdProp.setValue(record.getElementIdBuffer());
        this.bpmnProcessIdProp.setValue(record.getBpmnProcessIdBuffer());
        this.flowScopeKeyProp.setValue(record.getFlowScopeKey());
        this.versionProp.setValue(record.getVersion());
        this.processDefinitionKeyProp.setValue(record.getProcessDefinitionKey());
        this.processInstanceKeyProp.setValue(record.getProcessInstanceKey());
        this.bpmnElementTypeProp.setValue((Enum)record.getBpmnElementType());
        this.bpmnEventTypeProp.setValue((Enum)record.getBpmnEventType());
        this.parentProcessInstanceKeyProp.setValue(record.getParentProcessInstanceKey());
        this.parentElementInstanceKeyProp.setValue(record.getParentElementInstanceKey());
    }

    @JsonIgnore
    public DirectBuffer getBpmnProcessIdBuffer() {
        return this.bpmnProcessIdProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getElementIdBuffer() {
        return this.elementIdProp.getValue();
    }

    public ProcessInstanceRecord setBpmnProcessId(DirectBuffer directBuffer, int offset, int length) {
        this.bpmnProcessIdProp.setValue(directBuffer, offset, length);
        return this;
    }

    public String getBpmnProcessId() {
        return BufferUtil.bufferAsString((DirectBuffer)this.bpmnProcessIdProp.getValue());
    }

    public int getVersion() {
        return this.versionProp.getValue();
    }

    public long getProcessDefinitionKey() {
        return this.processDefinitionKeyProp.getValue();
    }

    public long getProcessInstanceKey() {
        return this.processInstanceKeyProp.getValue();
    }

    public ProcessInstanceRecord setProcessInstanceKey(long processInstanceKey) {
        this.processInstanceKeyProp.setValue(processInstanceKey);
        return this;
    }

    public String getElementId() {
        return BufferUtil.bufferAsString((DirectBuffer)this.elementIdProp.getValue());
    }

    public long getFlowScopeKey() {
        return this.flowScopeKeyProp.getValue();
    }

    public BpmnElementType getBpmnElementType() {
        return (BpmnElementType)this.bpmnElementTypeProp.getValue();
    }

    public long getParentProcessInstanceKey() {
        return this.parentProcessInstanceKeyProp.getValue();
    }

    public long getParentElementInstanceKey() {
        return this.parentElementInstanceKeyProp.getValue();
    }

    public ProcessInstanceRecord setParentElementInstanceKey(long parentElementInstanceKey) {
        this.parentElementInstanceKeyProp.setValue(parentElementInstanceKey);
        return this;
    }

    public BpmnEventType getBpmnEventType() {
        return (BpmnEventType)this.bpmnEventTypeProp.getValue();
    }

    public ProcessInstanceRecord setBpmnEventType(BpmnEventType bpmnEventType) {
        this.bpmnEventTypeProp.setValue((Enum)bpmnEventType);
        return this;
    }

    public ProcessInstanceRecord setParentProcessInstanceKey(long parentProcessInstanceKey) {
        this.parentProcessInstanceKeyProp.setValue(parentProcessInstanceKey);
        return this;
    }

    public ProcessInstanceRecord setBpmnElementType(BpmnElementType bpmnType) {
        this.bpmnElementTypeProp.setValue((Enum)bpmnType);
        return this;
    }

    public ProcessInstanceRecord setFlowScopeKey(long flowScopeKey) {
        this.flowScopeKeyProp.setValue(flowScopeKey);
        return this;
    }

    public ProcessInstanceRecord setElementId(String elementId) {
        this.elementIdProp.setValue(elementId);
        return this;
    }

    public ProcessInstanceRecord setElementId(DirectBuffer elementId) {
        return this.setElementId(elementId, 0, elementId.capacity());
    }

    public ProcessInstanceRecord setProcessDefinitionKey(long processDefinitionKey) {
        this.processDefinitionKeyProp.setValue(processDefinitionKey);
        return this;
    }

    public ProcessInstanceRecord setVersion(int version) {
        this.versionProp.setValue(version);
        return this;
    }

    public ProcessInstanceRecord setBpmnProcessId(String bpmnProcessId) {
        this.bpmnProcessIdProp.setValue(bpmnProcessId);
        return this;
    }

    public ProcessInstanceRecord setBpmnProcessId(DirectBuffer directBuffer) {
        this.bpmnProcessIdProp.setValue(directBuffer);
        return this;
    }

    public boolean hasParentProcess() {
        return this.getParentProcessInstanceKey() != -1L;
    }

    public ProcessInstanceRecord setElementId(DirectBuffer elementId, int offset, int length) {
        this.elementIdProp.setValue(elementId, offset, length);
        return this;
    }
}

