/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record;

import io.camunda.zeebe.protocol.record.MessageHeaderEncoder;
import io.camunda.zeebe.protocol.record.MetaAttribute;
import io.camunda.zeebe.protocol.record.RecordMetadataDecoder;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.VersionEncoder;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.ArrayUtil;
import org.agrona.sbe.MessageEncoderFlyweight;

public final class RecordMetadataEncoder
implements MessageEncoderFlyweight {
    public static final int BLOCK_LENGTH = 30;
    public static final int TEMPLATE_ID = 200;
    public static final int SCHEMA_ID = 0;
    public static final int SCHEMA_VERSION = 3;
    public static final String SEMANTIC_VERSION = "8.2.9";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final RecordMetadataEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    private final VersionEncoder brokerVersion = new VersionEncoder();

    public int sbeBlockLength() {
        return 30;
    }

    public int sbeTemplateId() {
        return 200;
    }

    public int sbeSchemaId() {
        return 0;
    }

    public int sbeSchemaVersion() {
        return 3;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public RecordMetadataEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.limit(offset + 30);
        return this;
    }

    public RecordMetadataEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(30).templateId(200).schemaId(0).version(3);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int recordTypeId() {
        return 1;
    }

    public static int recordTypeSinceVersion() {
        return 0;
    }

    public static int recordTypeEncodingOffset() {
        return 0;
    }

    public static int recordTypeEncodingLength() {
        return 1;
    }

    public static String recordTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public RecordMetadataEncoder recordType(RecordType value) {
        this.buffer.putByte(this.offset + 0, (byte)value.value());
        return this;
    }

    public static int requestStreamIdId() {
        return 2;
    }

    public static int requestStreamIdSinceVersion() {
        return 0;
    }

    public static int requestStreamIdEncodingOffset() {
        return 1;
    }

    public static int requestStreamIdEncodingLength() {
        return 4;
    }

    public static String requestStreamIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int requestStreamIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int requestStreamIdMinValue() {
        return -2147483647;
    }

    public static int requestStreamIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public RecordMetadataEncoder requestStreamId(int value) {
        this.buffer.putInt(this.offset + 1, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int requestIdId() {
        return 3;
    }

    public static int requestIdSinceVersion() {
        return 0;
    }

    public static int requestIdEncodingOffset() {
        return 5;
    }

    public static int requestIdEncodingLength() {
        return 8;
    }

    public static String requestIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long requestIdNullValue() {
        return -1L;
    }

    public static long requestIdMinValue() {
        return 0L;
    }

    public static long requestIdMaxValue() {
        return -2L;
    }

    public RecordMetadataEncoder requestId(long value) {
        this.buffer.putLong(this.offset + 5, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int protocolVersionId() {
        return 4;
    }

    public static int protocolVersionSinceVersion() {
        return 0;
    }

    public static int protocolVersionEncodingOffset() {
        return 13;
    }

    public static int protocolVersionEncodingLength() {
        return 2;
    }

    public static String protocolVersionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int protocolVersionNullValue() {
        return 65535;
    }

    public static int protocolVersionMinValue() {
        return 0;
    }

    public static int protocolVersionMaxValue() {
        return 65534;
    }

    public RecordMetadataEncoder protocolVersion(int value) {
        this.buffer.putShort(this.offset + 13, (short)value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int valueTypeId() {
        return 5;
    }

    public static int valueTypeSinceVersion() {
        return 0;
    }

    public static int valueTypeEncodingOffset() {
        return 15;
    }

    public static int valueTypeEncodingLength() {
        return 1;
    }

    public static String valueTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public RecordMetadataEncoder valueType(ValueType value) {
        this.buffer.putByte(this.offset + 15, (byte)value.value());
        return this;
    }

    public static int intentId() {
        return 6;
    }

    public static int intentSinceVersion() {
        return 0;
    }

    public static int intentEncodingOffset() {
        return 16;
    }

    public static int intentEncodingLength() {
        return 1;
    }

    public static String intentMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static short intentNullValue() {
        return 255;
    }

    public static short intentMinValue() {
        return 0;
    }

    public static short intentMaxValue() {
        return 254;
    }

    public RecordMetadataEncoder intent(short value) {
        this.buffer.putByte(this.offset + 16, (byte)value);
        return this;
    }

    public static int rejectionTypeId() {
        return 7;
    }

    public static int rejectionTypeSinceVersion() {
        return 0;
    }

    public static int rejectionTypeEncodingOffset() {
        return 17;
    }

    public static int rejectionTypeEncodingLength() {
        return 1;
    }

    public static String rejectionTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public RecordMetadataEncoder rejectionType(RejectionType value) {
        this.buffer.putByte(this.offset + 17, (byte)value.value());
        return this;
    }

    public static int brokerVersionId() {
        return 9;
    }

    public static int brokerVersionSinceVersion() {
        return 2;
    }

    public static int brokerVersionEncodingOffset() {
        return 18;
    }

    public static int brokerVersionEncodingLength() {
        return 12;
    }

    public static String brokerVersionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return "";
    }

    public VersionEncoder brokerVersion() {
        this.brokerVersion.wrap(this.buffer, this.offset + 18);
        return this.brokerVersion;
    }

    public static int rejectionReasonId() {
        return 8;
    }

    public static String rejectionReasonCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String rejectionReasonMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int rejectionReasonHeaderLength() {
        return 4;
    }

    public RecordMetadataEncoder putRejectionReason(DirectBuffer src, int srcOffset, int length) {
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public RecordMetadataEncoder putRejectionReason(byte[] src, int srcOffset, int length) {
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public RecordMetadataEncoder rejectionReason(String value) {
        byte[] bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(StandardCharsets.UTF_8);
        int length = bytes.length;
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, bytes, 0, length);
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        RecordMetadataDecoder decoder = new RecordMetadataDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.initialOffset, 30, 3);
        return decoder.appendTo(builder);
    }
}

