/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.client.auth;

import com.auth0.utils.Asserts;
import java.util.HashMap;
import java.util.Map;
import okhttp3.HttpUrl;

public class AuthorizeUrlBuilder {
    private final HttpUrl.Builder builder;
    private final Map<String, String> parameters;

    static AuthorizeUrlBuilder newInstance(HttpUrl baseUrl, String clientId, String redirectUri) {
        return new AuthorizeUrlBuilder(baseUrl, clientId, redirectUri);
    }

    private AuthorizeUrlBuilder(HttpUrl url, String clientId, String redirectUri) {
        Asserts.assertNotNull(url, "base url");
        Asserts.assertNotNull(clientId, "client id");
        Asserts.assertNotNull(redirectUri, "redirect uri");
        this.parameters = new HashMap<String, String>();
        this.builder = url.newBuilder().addPathSegment("authorize").addEncodedQueryParameter("redirect_uri", redirectUri).addQueryParameter("client_id", clientId);
        this.withParameter("response_type", "code");
    }

    public AuthorizeUrlBuilder withConnection(String connection) {
        Asserts.assertNotNull(connection, "connection");
        this.parameters.put("connection", connection);
        return this;
    }

    public AuthorizeUrlBuilder withAudience(String audience) {
        Asserts.assertNotNull(audience, "audience");
        this.parameters.put("audience", audience);
        return this;
    }

    public AuthorizeUrlBuilder withState(String state) {
        Asserts.assertNotNull(state, "state");
        this.parameters.put("state", state);
        return this;
    }

    public AuthorizeUrlBuilder withScope(String scope) {
        Asserts.assertNotNull(scope, "scope");
        this.parameters.put("scope", scope);
        return this;
    }

    public AuthorizeUrlBuilder withResponseType(String responseType) {
        Asserts.assertNotNull(responseType, "response type");
        this.parameters.put("response_type", responseType);
        return this;
    }

    public AuthorizeUrlBuilder withOrganization(String organization) {
        Asserts.assertNotNull(organization, "organization");
        this.parameters.put("organization", organization);
        return this;
    }

    public AuthorizeUrlBuilder withInvitation(String invitation) {
        Asserts.assertNotNull(invitation, "invitation");
        this.parameters.put("invitation", invitation);
        return this;
    }

    public AuthorizeUrlBuilder withParameter(String name, String value) {
        Asserts.assertNotNull(name, "name");
        Asserts.assertNotNull(value, "value");
        this.parameters.put(name, value);
        return this;
    }

    public String build() {
        for (Map.Entry<String, String> p : this.parameters.entrySet()) {
            this.builder.addQueryParameter(p.getKey(), p.getValue());
        }
        return this.builder.build().toString();
    }
}

