/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.client.mgmt;

import com.auth0.client.mgmt.BaseManagementEntity;
import com.auth0.client.mgmt.filter.ClientFilter;
import com.auth0.client.mgmt.filter.FieldsFilter;
import com.auth0.json.mgmt.client.Client;
import com.auth0.json.mgmt.client.ClientsPage;
import com.auth0.net.CustomRequest;
import com.auth0.net.EmptyBodyRequest;
import com.auth0.net.Request;
import com.auth0.net.VoidRequest;
import com.auth0.utils.Asserts;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.Map;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;

public class ClientsEntity
extends BaseManagementEntity {
    ClientsEntity(OkHttpClient client, HttpUrl baseUrl, String apiToken) {
        super(client, baseUrl, apiToken);
    }

    @Deprecated
    public Request<List<Client>> list() {
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/clients").build().toString();
        CustomRequest<List<Client>> request = new CustomRequest<List<Client>>(this.client, url, "GET", new TypeReference<List<Client>>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }

    public Request<ClientsPage> list(ClientFilter filter) {
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments("api/v2/clients");
        if (filter != null) {
            for (Map.Entry<String, Object> e : filter.getAsMap().entrySet()) {
                builder.addQueryParameter(e.getKey(), String.valueOf(e.getValue()));
            }
        }
        String url = builder.build().toString();
        CustomRequest<ClientsPage> request = new CustomRequest<ClientsPage>(this.client, url, "GET", new TypeReference<ClientsPage>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }

    public Request<Client> get(String clientId) {
        Asserts.assertNotNull(clientId, "client id");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/clients").addPathSegment(clientId).build().toString();
        CustomRequest<Client> request = new CustomRequest<Client>(this.client, url, "GET", new TypeReference<Client>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }

    public Request<Client> get(String clientId, FieldsFilter filter) {
        Asserts.assertNotNull(clientId, "client id");
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments("api/v2/clients").addPathSegment(clientId);
        if (filter != null) {
            for (Map.Entry<String, Object> e : filter.getAsMap().entrySet()) {
                builder.addQueryParameter(e.getKey(), String.valueOf(e.getValue()));
            }
        }
        String url = builder.build().toString();
        CustomRequest<Client> request = new CustomRequest<Client>(this.client, url, "GET", new TypeReference<Client>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }

    public Request<Client> create(Client client) {
        Asserts.assertNotNull(client, "client");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/clients").build().toString();
        CustomRequest<Client> request = new CustomRequest<Client>(this.client, url, "POST", new TypeReference<Client>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        request.setBody(client);
        return request;
    }

    public Request<Void> delete(String clientId) {
        Asserts.assertNotNull(clientId, "client id");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/clients").addPathSegment(clientId).build().toString();
        VoidRequest request = new VoidRequest(this.client, url, "DELETE");
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }

    public Request<Client> update(String clientId, Client client) {
        Asserts.assertNotNull(clientId, "client id");
        Asserts.assertNotNull(client, "client");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/clients").addPathSegment(clientId).build().toString();
        CustomRequest<Client> request = new CustomRequest<Client>(this.client, url, "PATCH", new TypeReference<Client>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        request.setBody(client);
        return request;
    }

    public Request<Client> rotateSecret(String clientId) {
        Asserts.assertNotNull(clientId, "client id");
        Asserts.assertNotNull(this.client, "client");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/clients").addPathSegment(clientId).addPathSegment("rotate-secret").build().toString();
        EmptyBodyRequest<Client> request = new EmptyBodyRequest<Client>(this.client, url, "POST", new TypeReference<Client>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }
}

