/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.client.mgmt;

import com.auth0.client.mgmt.BaseManagementEntity;
import com.auth0.client.mgmt.filter.DeviceCredentialsFilter;
import com.auth0.json.mgmt.DeviceCredentials;
import com.auth0.net.CustomRequest;
import com.auth0.net.Request;
import com.auth0.net.VoidRequest;
import com.auth0.utils.Asserts;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.Map;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;

public class DeviceCredentialsEntity
extends BaseManagementEntity {
    DeviceCredentialsEntity(OkHttpClient client, HttpUrl baseUrl, String apiToken) {
        super(client, baseUrl, apiToken);
    }

    public Request<List<DeviceCredentials>> list(DeviceCredentialsFilter filter) {
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments("api/v2/device-credentials");
        if (filter != null) {
            for (Map.Entry<String, Object> e : filter.getAsMap().entrySet()) {
                builder.addQueryParameter(e.getKey(), String.valueOf(e.getValue()));
            }
        }
        String url = builder.build().toString();
        CustomRequest<List<DeviceCredentials>> request = new CustomRequest<List<DeviceCredentials>>(this.client, url, "GET", new TypeReference<List<DeviceCredentials>>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }

    public Request<DeviceCredentials> create(DeviceCredentials deviceCredentials) {
        Asserts.assertNotNull(deviceCredentials, "device credentials");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/device-credentials").build().toString();
        CustomRequest<DeviceCredentials> request = new CustomRequest<DeviceCredentials>(this.client, url, "POST", new TypeReference<DeviceCredentials>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        request.setBody(deviceCredentials);
        return request;
    }

    public Request<Void> delete(String deviceCredentialsId) {
        Asserts.assertNotNull(deviceCredentialsId, "device credentials id");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/device-credentials").addPathSegment(deviceCredentialsId).build().toString();
        VoidRequest request = new VoidRequest(this.client, url, "DELETE");
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }
}

