/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.client.mgmt;

import com.auth0.client.mgmt.BaseManagementEntity;
import com.auth0.client.mgmt.filter.FieldsFilter;
import com.auth0.json.mgmt.emailproviders.EmailProvider;
import com.auth0.net.CustomRequest;
import com.auth0.net.Request;
import com.auth0.net.VoidRequest;
import com.auth0.utils.Asserts;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Map;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;

public class EmailProviderEntity
extends BaseManagementEntity {
    EmailProviderEntity(OkHttpClient client, HttpUrl baseUrl, String apiToken) {
        super(client, baseUrl, apiToken);
    }

    public Request<EmailProvider> get(FieldsFilter filter) {
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments("api/v2/emails/provider");
        if (filter != null) {
            for (Map.Entry<String, Object> e : filter.getAsMap().entrySet()) {
                builder.addQueryParameter(e.getKey(), String.valueOf(e.getValue()));
            }
        }
        String url = builder.build().toString();
        CustomRequest<EmailProvider> request = new CustomRequest<EmailProvider>(this.client, url, "GET", new TypeReference<EmailProvider>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }

    public Request<EmailProvider> setup(EmailProvider emailProvider) {
        Asserts.assertNotNull(emailProvider, "email provider");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/emails/provider").build().toString();
        CustomRequest<EmailProvider> request = new CustomRequest<EmailProvider>(this.client, url, "POST", new TypeReference<EmailProvider>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        request.setBody(emailProvider);
        return request;
    }

    public Request<Void> delete() {
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/emails/provider").build().toString();
        VoidRequest request = new VoidRequest(this.client, url, "DELETE");
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }

    public Request<EmailProvider> update(EmailProvider emailProvider) {
        Asserts.assertNotNull(emailProvider, "email provider");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/emails/provider").build().toString();
        CustomRequest<EmailProvider> request = new CustomRequest<EmailProvider>(this.client, url, "PATCH", new TypeReference<EmailProvider>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        request.setBody(emailProvider);
        return request;
    }
}

