/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.client.mgmt;

import com.auth0.client.mgmt.BaseManagementEntity;
import com.auth0.json.mgmt.Key;
import com.auth0.net.CustomRequest;
import com.auth0.net.EmptyBodyRequest;
import com.auth0.net.Request;
import com.auth0.utils.Asserts;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;

public class KeysEntity
extends BaseManagementEntity {
    KeysEntity(OkHttpClient client, HttpUrl baseUrl, String apiToken) {
        super(client, baseUrl, apiToken);
    }

    public Request<List<Key>> list() {
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addEncodedPathSegments("api/v2/keys/signing");
        String url = builder.build().toString();
        CustomRequest<List<Key>> request = new CustomRequest<List<Key>>(this.client, url, "GET", new TypeReference<List<Key>>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }

    public Request<Key> get(String kid) {
        Asserts.assertNotNull(kid, "kid");
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments("api/v2/keys/signing").addPathSegment(kid);
        String url = builder.build().toString();
        CustomRequest<Key> request = new CustomRequest<Key>(this.client, url, "GET", new TypeReference<Key>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }

    public Request<Key> rotate() {
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/keys/signing/rotate").build().toString();
        EmptyBodyRequest<Key> request = new EmptyBodyRequest<Key>(this.client, url, "POST", new TypeReference<Key>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }

    public Request<Key> revoke(String kid) {
        Asserts.assertNotNull(kid, "kid");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/keys/signing/").addPathSegment(kid).addPathSegment("revoke").build().toString();
        EmptyBodyRequest<Key> request = new EmptyBodyRequest<Key>(this.client, url, "PUT", new TypeReference<Key>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }
}

