/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.client.mgmt;

import com.auth0.client.mgmt.BaseManagementEntity;
import com.auth0.client.mgmt.filter.LogEventFilter;
import com.auth0.json.mgmt.logevents.LogEvent;
import com.auth0.json.mgmt.logevents.LogEventsPage;
import com.auth0.net.CustomRequest;
import com.auth0.net.Request;
import com.auth0.utils.Asserts;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Map;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;

public class LogEventsEntity
extends BaseManagementEntity {
    LogEventsEntity(OkHttpClient client, HttpUrl baseUrl, String apiToken) {
        super(client, baseUrl, apiToken);
    }

    public Request<LogEventsPage> list(LogEventFilter filter) {
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments("api/v2/logs");
        if (filter != null) {
            for (Map.Entry<String, Object> e : filter.getAsMap().entrySet()) {
                if ("q".equals(e.getKey())) {
                    builder.addEncodedQueryParameter(e.getKey(), String.valueOf(e.getValue()));
                    continue;
                }
                builder.addQueryParameter(e.getKey(), String.valueOf(e.getValue()));
            }
        }
        String url = builder.build().toString();
        CustomRequest<LogEventsPage> request = new CustomRequest<LogEventsPage>(this.client, url, "GET", new TypeReference<LogEventsPage>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }

    public Request<LogEvent> get(String logEventId) {
        Asserts.assertNotNull(logEventId, "log event id");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/logs").addPathSegment(logEventId).build().toString();
        CustomRequest<LogEvent> request = new CustomRequest<LogEvent>(this.client, url, "GET", new TypeReference<LogEvent>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }
}

