/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.client.mgmt;

import com.auth0.client.mgmt.BaseManagementEntity;
import com.auth0.json.mgmt.logstreams.LogStream;
import com.auth0.net.CustomRequest;
import com.auth0.net.Request;
import com.auth0.net.VoidRequest;
import com.auth0.utils.Asserts;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;

public class LogStreamsEntity
extends BaseManagementEntity {
    private static final String LOG_STREAMS_PATH = "api/v2/log-streams";
    private static final String AUTHORIZATION_HEADER = "Authorization";

    LogStreamsEntity(OkHttpClient client, HttpUrl baseUrl, String apiToken) {
        super(client, baseUrl, apiToken);
    }

    public Request<List<LogStream>> list() {
        String url = this.baseUrl.newBuilder().addPathSegments(LOG_STREAMS_PATH).build().toString();
        CustomRequest<List<LogStream>> request = new CustomRequest<List<LogStream>>(this.client, url, "GET", new TypeReference<List<LogStream>>(){});
        request.addHeader(AUTHORIZATION_HEADER, "Bearer " + this.apiToken);
        return request;
    }

    public Request<LogStream> get(String logStreamId) {
        Asserts.assertNotNull(logStreamId, "log stream id");
        String url = this.baseUrl.newBuilder().addPathSegments(LOG_STREAMS_PATH).addPathSegment(logStreamId).build().toString();
        CustomRequest<LogStream> request = new CustomRequest<LogStream>(this.client, url, "GET", new TypeReference<LogStream>(){});
        request.addHeader(AUTHORIZATION_HEADER, "Bearer " + this.apiToken);
        return request;
    }

    public Request<LogStream> create(LogStream logStream) {
        Asserts.assertNotNull(logStream, "log stream");
        String url = this.baseUrl.newBuilder().addPathSegments(LOG_STREAMS_PATH).build().toString();
        CustomRequest<LogStream> request = new CustomRequest<LogStream>(this.client, url, "POST", new TypeReference<LogStream>(){});
        request.addHeader(AUTHORIZATION_HEADER, "Bearer " + this.apiToken);
        request.setBody(logStream);
        return request;
    }

    public Request<LogStream> update(String logStreamId, LogStream logStream) {
        Asserts.assertNotNull(logStreamId, "log stream id");
        Asserts.assertNotNull(logStream, "log stream");
        String url = this.baseUrl.newBuilder().addPathSegments(LOG_STREAMS_PATH).addPathSegment(logStreamId).build().toString();
        CustomRequest<LogStream> request = new CustomRequest<LogStream>(this.client, url, "PATCH", new TypeReference<LogStream>(){});
        request.addHeader(AUTHORIZATION_HEADER, "Bearer " + this.apiToken);
        request.setBody(logStream);
        return request;
    }

    public Request<Void> delete(String logStreamId) {
        Asserts.assertNotNull(logStreamId, "log stream id");
        String url = this.baseUrl.newBuilder().addPathSegments(LOG_STREAMS_PATH).addPathSegment(logStreamId).build().toString();
        VoidRequest request = new VoidRequest(this.client, url, "DELETE");
        request.addHeader(AUTHORIZATION_HEADER, "Bearer " + this.apiToken);
        return request;
    }
}

