/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.client.mgmt;

import com.auth0.client.HttpOptions;
import com.auth0.client.LoggingOptions;
import com.auth0.client.ProxyOptions;
import com.auth0.client.mgmt.ActionsEntity;
import com.auth0.client.mgmt.AttackProtectionEntity;
import com.auth0.client.mgmt.BlacklistsEntity;
import com.auth0.client.mgmt.BrandingEntity;
import com.auth0.client.mgmt.ClientGrantsEntity;
import com.auth0.client.mgmt.ClientsEntity;
import com.auth0.client.mgmt.ConnectionsEntity;
import com.auth0.client.mgmt.DeviceCredentialsEntity;
import com.auth0.client.mgmt.EmailProviderEntity;
import com.auth0.client.mgmt.EmailTemplatesEntity;
import com.auth0.client.mgmt.GrantsEntity;
import com.auth0.client.mgmt.GuardianEntity;
import com.auth0.client.mgmt.JobsEntity;
import com.auth0.client.mgmt.KeysEntity;
import com.auth0.client.mgmt.LogEventsEntity;
import com.auth0.client.mgmt.LogStreamsEntity;
import com.auth0.client.mgmt.OrganizationsEntity;
import com.auth0.client.mgmt.ResourceServerEntity;
import com.auth0.client.mgmt.RolesEntity;
import com.auth0.client.mgmt.RulesConfigsEntity;
import com.auth0.client.mgmt.RulesEntity;
import com.auth0.client.mgmt.StatsEntity;
import com.auth0.client.mgmt.TenantsEntity;
import com.auth0.client.mgmt.TicketsEntity;
import com.auth0.client.mgmt.UserBlocksEntity;
import com.auth0.client.mgmt.UsersEntity;
import com.auth0.net.RateLimitInterceptor;
import com.auth0.net.Telemetry;
import com.auth0.net.TelemetryInterceptor;
import com.auth0.utils.Asserts;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.Authenticator;
import okhttp3.Dispatcher;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import okhttp3.logging.HttpLoggingInterceptor;

public class ManagementAPI {
    private final HttpUrl baseUrl;
    private String apiToken;
    private final OkHttpClient client;
    private final TelemetryInterceptor telemetry;
    private final HttpLoggingInterceptor logging;

    public ManagementAPI(String domain, String apiToken, HttpOptions options) {
        Asserts.assertNotNull(domain, "domain");
        Asserts.assertNotNull(apiToken, "api token");
        this.baseUrl = this.createBaseUrl(domain);
        if (this.baseUrl == null) {
            throw new IllegalArgumentException("The domain had an invalid format and couldn't be parsed as an URL.");
        }
        this.apiToken = apiToken;
        this.telemetry = new TelemetryInterceptor();
        this.logging = new HttpLoggingInterceptor();
        this.client = this.buildNetworkingClient(options);
    }

    public ManagementAPI(String domain, String apiToken) {
        this(domain, apiToken, new HttpOptions());
    }

    private OkHttpClient buildNetworkingClient(HttpOptions options) {
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
        ProxyOptions proxyOptions = options.getProxyOptions();
        if (proxyOptions != null) {
            clientBuilder.proxy(proxyOptions.getProxy());
            final String proxyAuth = proxyOptions.getBasicAuthentication();
            if (proxyAuth != null) {
                clientBuilder.proxyAuthenticator(new Authenticator(){
                    private static final String PROXY_AUTHORIZATION_HEADER = "Proxy-Authorization";

                    public Request authenticate(Route route, Response response) throws IOException {
                        if (response.request().header(PROXY_AUTHORIZATION_HEADER) != null) {
                            return null;
                        }
                        return response.request().newBuilder().header(PROXY_AUTHORIZATION_HEADER, proxyAuth).build();
                    }
                });
            }
        }
        this.configureLogging(options.getLoggingOptions());
        Dispatcher dispatcher = new Dispatcher();
        dispatcher.setMaxRequestsPerHost(options.getMaxRequestsPerHost());
        dispatcher.setMaxRequests(options.getMaxRequests());
        return clientBuilder.addInterceptor((Interceptor)this.logging).addInterceptor((Interceptor)this.telemetry).addInterceptor((Interceptor)new RateLimitInterceptor(options.getManagementAPIMaxRetries())).connectTimeout((long)options.getConnectTimeout(), TimeUnit.SECONDS).readTimeout((long)options.getReadTimeout(), TimeUnit.SECONDS).dispatcher(dispatcher).build();
    }

    public void setApiToken(String apiToken) {
        Asserts.assertNotNull(apiToken, "api token");
        this.apiToken = apiToken;
    }

    public void doNotSendTelemetry() {
        this.telemetry.setEnabled(false);
    }

    public void setTelemetry(Telemetry telemetry) {
        this.telemetry.setTelemetry(telemetry);
    }

    @Deprecated
    public void setLoggingEnabled(boolean enabled) {
        this.logging.setLevel(enabled ? HttpLoggingInterceptor.Level.BODY : HttpLoggingInterceptor.Level.NONE);
    }

    private void configureLogging(LoggingOptions loggingOptions) {
        if (loggingOptions == null) {
            this.logging.setLevel(HttpLoggingInterceptor.Level.NONE);
            return;
        }
        switch (loggingOptions.getLogLevel()) {
            case BASIC: {
                this.logging.setLevel(HttpLoggingInterceptor.Level.BASIC);
                break;
            }
            case HEADERS: {
                this.logging.setLevel(HttpLoggingInterceptor.Level.HEADERS);
                break;
            }
            case BODY: {
                this.logging.setLevel(HttpLoggingInterceptor.Level.BODY);
                break;
            }
            default: {
                this.logging.setLevel(HttpLoggingInterceptor.Level.NONE);
            }
        }
        for (String header : loggingOptions.getHeadersToRedact()) {
            this.logging.redactHeader(header);
        }
    }

    OkHttpClient getClient() {
        return this.client;
    }

    HttpUrl getBaseUrl() {
        return this.baseUrl;
    }

    private HttpUrl createBaseUrl(String domain) {
        String url = domain;
        if (!domain.startsWith("https://") && !domain.startsWith("http://")) {
            url = "https://" + domain;
        }
        return HttpUrl.parse((String)url);
    }

    public BrandingEntity branding() {
        return new BrandingEntity(this.client, this.baseUrl, this.apiToken);
    }

    public ClientGrantsEntity clientGrants() {
        return new ClientGrantsEntity(this.client, this.baseUrl, this.apiToken);
    }

    public ClientsEntity clients() {
        return new ClientsEntity(this.client, this.baseUrl, this.apiToken);
    }

    public ConnectionsEntity connections() {
        return new ConnectionsEntity(this.client, this.baseUrl, this.apiToken);
    }

    public DeviceCredentialsEntity deviceCredentials() {
        return new DeviceCredentialsEntity(this.client, this.baseUrl, this.apiToken);
    }

    public GrantsEntity grants() {
        return new GrantsEntity(this.client, this.baseUrl, this.apiToken);
    }

    public LogEventsEntity logEvents() {
        return new LogEventsEntity(this.client, this.baseUrl, this.apiToken);
    }

    public LogStreamsEntity logStreams() {
        return new LogStreamsEntity(this.client, this.baseUrl, this.apiToken);
    }

    public RulesEntity rules() {
        return new RulesEntity(this.client, this.baseUrl, this.apiToken);
    }

    public RulesConfigsEntity rulesConfigs() {
        return new RulesConfigsEntity(this.client, this.baseUrl, this.apiToken);
    }

    public UserBlocksEntity userBlocks() {
        return new UserBlocksEntity(this.client, this.baseUrl, this.apiToken);
    }

    public UsersEntity users() {
        return new UsersEntity(this.client, this.baseUrl, this.apiToken);
    }

    public BlacklistsEntity blacklists() {
        return new BlacklistsEntity(this.client, this.baseUrl, this.apiToken);
    }

    public EmailTemplatesEntity emailTemplates() {
        return new EmailTemplatesEntity(this.client, this.baseUrl, this.apiToken);
    }

    public EmailProviderEntity emailProvider() {
        return new EmailProviderEntity(this.client, this.baseUrl, this.apiToken);
    }

    public GuardianEntity guardian() {
        return new GuardianEntity(this.client, this.baseUrl, this.apiToken);
    }

    public StatsEntity stats() {
        return new StatsEntity(this.client, this.baseUrl, this.apiToken);
    }

    public TenantsEntity tenants() {
        return new TenantsEntity(this.client, this.baseUrl, this.apiToken);
    }

    public TicketsEntity tickets() {
        return new TicketsEntity(this.client, this.baseUrl, this.apiToken);
    }

    public ResourceServerEntity resourceServers() {
        return new ResourceServerEntity(this.client, this.baseUrl, this.apiToken);
    }

    public JobsEntity jobs() {
        return new JobsEntity(this.client, this.baseUrl, this.apiToken);
    }

    public RolesEntity roles() {
        return new RolesEntity(this.client, this.baseUrl, this.apiToken);
    }

    public OrganizationsEntity organizations() {
        return new OrganizationsEntity(this.client, this.baseUrl, this.apiToken);
    }

    public ActionsEntity actions() {
        return new ActionsEntity(this.client, this.baseUrl, this.apiToken);
    }

    public AttackProtectionEntity attackProtection() {
        return new AttackProtectionEntity(this.client, this.baseUrl, this.apiToken);
    }

    public KeysEntity keys() {
        return new KeysEntity(this.client, this.baseUrl, this.apiToken);
    }
}

