/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.client.mgmt;

import com.auth0.client.mgmt.BaseManagementEntity;
import com.auth0.client.mgmt.filter.BaseFilter;
import com.auth0.client.mgmt.filter.FieldsFilter;
import com.auth0.client.mgmt.filter.InvitationsFilter;
import com.auth0.client.mgmt.filter.PageFilter;
import com.auth0.json.mgmt.RolesPage;
import com.auth0.json.mgmt.organizations.EnabledConnection;
import com.auth0.json.mgmt.organizations.EnabledConnectionsPage;
import com.auth0.json.mgmt.organizations.Invitation;
import com.auth0.json.mgmt.organizations.InvitationsPage;
import com.auth0.json.mgmt.organizations.Members;
import com.auth0.json.mgmt.organizations.MembersPage;
import com.auth0.json.mgmt.organizations.Organization;
import com.auth0.json.mgmt.organizations.OrganizationsPage;
import com.auth0.json.mgmt.organizations.Roles;
import com.auth0.net.CustomRequest;
import com.auth0.net.Request;
import com.auth0.net.VoidRequest;
import com.auth0.utils.Asserts;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Map;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;

public class OrganizationsEntity
extends BaseManagementEntity {
    private static final String ORGS_PATH = "api/v2/organizations";
    private static final String AUTHORIZATION_HEADER = "Authorization";

    OrganizationsEntity(OkHttpClient client, HttpUrl baseUrl, String apiToken) {
        super(client, baseUrl, apiToken);
    }

    public Request<OrganizationsPage> list(PageFilter filter) {
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments(ORGS_PATH);
        this.applyFilter(filter, builder);
        String url = builder.build().toString();
        CustomRequest<OrganizationsPage> request = new CustomRequest<OrganizationsPage>(this.client, url, "GET", new TypeReference<OrganizationsPage>(){});
        request.addHeader(AUTHORIZATION_HEADER, "Bearer " + this.apiToken);
        return request;
    }

    public Request<Organization> get(String orgId) {
        Asserts.assertNotNull(orgId, "organization ID");
        String url = this.baseUrl.newBuilder().addPathSegments(ORGS_PATH).addPathSegment(orgId).build().toString();
        CustomRequest<Organization> request = new CustomRequest<Organization>(this.client, url, "GET", new TypeReference<Organization>(){});
        request.addHeader(AUTHORIZATION_HEADER, "Bearer " + this.apiToken);
        return request;
    }

    public Request<Organization> getByName(String orgName) {
        Asserts.assertNotNull(orgName, "organization name");
        String url = this.baseUrl.newBuilder().addPathSegments(ORGS_PATH).addPathSegment("name").addPathSegment(orgName).build().toString();
        CustomRequest<Organization> request = new CustomRequest<Organization>(this.client, url, "GET", new TypeReference<Organization>(){});
        request.addHeader(AUTHORIZATION_HEADER, "Bearer " + this.apiToken);
        return request;
    }

    public Request<Organization> create(Organization organization) {
        Asserts.assertNotNull(organization, "organization");
        String url = this.baseUrl.newBuilder().addPathSegments(ORGS_PATH).build().toString();
        CustomRequest<Organization> request = new CustomRequest<Organization>(this.client, url, "POST", new TypeReference<Organization>(){});
        request.addHeader(AUTHORIZATION_HEADER, "Bearer " + this.apiToken);
        request.setBody(organization);
        return request;
    }

    public Request<Organization> update(String orgId, Organization organization) {
        Asserts.assertNotNull(orgId, "organization ID");
        Asserts.assertNotNull(organization, "organization");
        String url = this.baseUrl.newBuilder().addPathSegments(ORGS_PATH).addPathSegment(orgId).build().toString();
        CustomRequest<Organization> request = new CustomRequest<Organization>(this.client, url, "PATCH", new TypeReference<Organization>(){});
        request.addHeader(AUTHORIZATION_HEADER, "Bearer " + this.apiToken);
        request.setBody(organization);
        return request;
    }

    public Request<Void> delete(String orgId) {
        Asserts.assertNotNull(orgId, "organization ID");
        String url = this.baseUrl.newBuilder().addPathSegments(ORGS_PATH).addPathSegment(orgId).build().toString();
        VoidRequest voidRequest = new VoidRequest(this.client, url, "DELETE");
        voidRequest.addHeader(AUTHORIZATION_HEADER, "Bearer " + this.apiToken);
        return voidRequest;
    }

    public Request<MembersPage> getMembers(String orgId, PageFilter filter) {
        Asserts.assertNotNull(orgId, "organization ID");
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments(ORGS_PATH).addPathSegment(orgId).addPathSegment("members");
        this.applyFilter(filter, builder);
        String url = builder.build().toString();
        CustomRequest<MembersPage> request = new CustomRequest<MembersPage>(this.client, url, "GET", new TypeReference<MembersPage>(){});
        request.addHeader(AUTHORIZATION_HEADER, "Bearer " + this.apiToken);
        return request;
    }

    public Request<Void> addMembers(String orgId, Members members) {
        Asserts.assertNotNull(orgId, "organization ID");
        Asserts.assertNotNull(members, "members");
        String url = this.baseUrl.newBuilder().addPathSegments(ORGS_PATH).addPathSegment(orgId).addPathSegment("members").build().toString();
        VoidRequest request = new VoidRequest(this.client, url, "POST");
        request.addHeader(AUTHORIZATION_HEADER, "Bearer " + this.apiToken);
        request.setBody(members);
        return request;
    }

    public Request<Void> deleteMembers(String orgId, Members members) {
        Asserts.assertNotNull(orgId, "organization ID");
        Asserts.assertNotNull(members, "members");
        String url = this.baseUrl.newBuilder().addPathSegments(ORGS_PATH).addPathSegment(orgId).addPathSegment("members").build().toString();
        VoidRequest request = new VoidRequest(this.client, url, "DELETE");
        request.addHeader(AUTHORIZATION_HEADER, "Bearer " + this.apiToken);
        request.setBody(members);
        return request;
    }

    public Request<EnabledConnectionsPage> getConnections(String orgId, PageFilter filter) {
        Asserts.assertNotNull(orgId, "organization ID");
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments(ORGS_PATH).addPathSegment(orgId).addPathSegment("enabled_connections");
        this.applyFilter(filter, builder);
        String url = builder.build().toString();
        CustomRequest<EnabledConnectionsPage> request = new CustomRequest<EnabledConnectionsPage>(this.client, url, "GET", new TypeReference<EnabledConnectionsPage>(){});
        request.addHeader(AUTHORIZATION_HEADER, "Bearer " + this.apiToken);
        return request;
    }

    public Request<EnabledConnection> getConnection(String orgId, String connectionId) {
        Asserts.assertNotNull(orgId, "organization ID");
        Asserts.assertNotNull(connectionId, "connection ID");
        String url = this.baseUrl.newBuilder().addPathSegments(ORGS_PATH).addPathSegment(orgId).addPathSegment("enabled_connections").addPathSegment(connectionId).build().toString();
        CustomRequest<EnabledConnection> request = new CustomRequest<EnabledConnection>(this.client, url, "GET", new TypeReference<EnabledConnection>(){});
        request.addHeader(AUTHORIZATION_HEADER, "Bearer " + this.apiToken);
        return request;
    }

    public Request<EnabledConnection> addConnection(String orgId, EnabledConnection connection) {
        Asserts.assertNotNull(orgId, "organization ID");
        Asserts.assertNotNull(connection, "connection");
        String url = this.baseUrl.newBuilder().addPathSegments(ORGS_PATH).addPathSegment(orgId).addPathSegment("enabled_connections").build().toString();
        CustomRequest<EnabledConnection> request = new CustomRequest<EnabledConnection>(this.client, url, "POST", new TypeReference<EnabledConnection>(){});
        request.addHeader(AUTHORIZATION_HEADER, "Bearer " + this.apiToken);
        request.setBody(connection);
        return request;
    }

    public Request<Void> deleteConnection(String orgId, String connectionId) {
        Asserts.assertNotNull(orgId, "organization ID");
        Asserts.assertNotNull(connectionId, "connection ID");
        String url = this.baseUrl.newBuilder().addPathSegments(ORGS_PATH).addPathSegment(orgId).addPathSegment("enabled_connections").addPathSegment(connectionId).build().toString();
        VoidRequest voidRequest = new VoidRequest(this.client, url, "DELETE");
        voidRequest.addHeader(AUTHORIZATION_HEADER, "Bearer " + this.apiToken);
        return voidRequest;
    }

    public Request<EnabledConnection> updateConnection(String orgId, String connectionId, EnabledConnection connection) {
        Asserts.assertNotNull(orgId, "organization ID");
        Asserts.assertNotNull(connectionId, "connection ID");
        Asserts.assertNotNull(connection, "connection");
        String url = this.baseUrl.newBuilder().addPathSegments(ORGS_PATH).addPathSegment(orgId).addPathSegment("enabled_connections").addPathSegment(connectionId).build().toString();
        CustomRequest<EnabledConnection> request = new CustomRequest<EnabledConnection>(this.client, url, "PATCH", new TypeReference<EnabledConnection>(){});
        request.addHeader(AUTHORIZATION_HEADER, "Bearer " + this.apiToken);
        request.setBody(connection);
        return request;
    }

    public Request<RolesPage> getRoles(String orgId, String userId, PageFilter filter) {
        Asserts.assertNotNull(orgId, "organization ID");
        Asserts.assertNotNull(userId, "user ID");
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments(ORGS_PATH).addPathSegment(orgId).addPathSegment("members").addPathSegment(userId).addPathSegment("roles");
        this.applyFilter(filter, builder);
        String url = builder.build().toString();
        CustomRequest<RolesPage> request = new CustomRequest<RolesPage>(this.client, url, "GET", new TypeReference<RolesPage>(){});
        request.addHeader(AUTHORIZATION_HEADER, "Bearer " + this.apiToken);
        return request;
    }

    public Request<Void> addRoles(String orgId, String userId, Roles roles) {
        Asserts.assertNotNull(orgId, "organization ID");
        Asserts.assertNotNull(userId, "user ID");
        Asserts.assertNotNull(roles, "roles");
        String url = this.baseUrl.newBuilder().addPathSegments(ORGS_PATH).addPathSegment(orgId).addPathSegment("members").addPathSegment(userId).addPathSegment("roles").build().toString();
        VoidRequest request = new VoidRequest(this.client, url, "POST");
        request.addHeader(AUTHORIZATION_HEADER, "Bearer " + this.apiToken);
        request.setBody(roles);
        return request;
    }

    public Request<Void> deleteRoles(String orgId, String userId, Roles roles) {
        Asserts.assertNotNull(orgId, "organization ID");
        Asserts.assertNotNull(userId, "user ID");
        Asserts.assertNotNull(roles, "roles");
        String url = this.baseUrl.newBuilder().addPathSegments(ORGS_PATH).addPathSegment(orgId).addPathSegment("members").addPathSegment(userId).addPathSegment("roles").build().toString();
        VoidRequest request = new VoidRequest(this.client, url, "DELETE");
        request.addHeader(AUTHORIZATION_HEADER, "Bearer " + this.apiToken);
        request.setBody(roles);
        return request;
    }

    public Request<Invitation> createInvitation(String orgId, Invitation invitation) {
        Asserts.assertNotNull(orgId, "organization ID");
        Asserts.assertNotNull(invitation, "invitation");
        String url = this.baseUrl.newBuilder().addPathSegments(ORGS_PATH).addPathSegment(orgId).addPathSegment("invitations").build().toString();
        CustomRequest<Invitation> request = new CustomRequest<Invitation>(this.client, url, "POST", new TypeReference<Invitation>(){});
        request.addHeader(AUTHORIZATION_HEADER, "Bearer " + this.apiToken);
        request.setBody(invitation);
        return request;
    }

    public Request<Invitation> getInvitation(String orgId, String invitationId, FieldsFilter filter) {
        Asserts.assertNotNull(orgId, "organization ID");
        Asserts.assertNotNull(invitationId, "invitation ID");
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments(ORGS_PATH).addPathSegment(orgId).addPathSegment("invitations").addPathSegment(invitationId);
        this.applyFilter(filter, builder);
        String url = builder.build().toString();
        CustomRequest<Invitation> request = new CustomRequest<Invitation>(this.client, url, "GET", new TypeReference<Invitation>(){});
        request.addHeader(AUTHORIZATION_HEADER, "Bearer " + this.apiToken);
        return request;
    }

    public Request<InvitationsPage> getInvitations(String orgId, InvitationsFilter filter) {
        Asserts.assertNotNull(orgId, "organization ID");
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments(ORGS_PATH).addPathSegment(orgId).addPathSegment("invitations");
        this.applyFilter(filter, builder);
        String url = builder.build().toString();
        CustomRequest<InvitationsPage> request = new CustomRequest<InvitationsPage>(this.client, url, "GET", new TypeReference<InvitationsPage>(){});
        request.addHeader(AUTHORIZATION_HEADER, "Bearer " + this.apiToken);
        return request;
    }

    public Request<Void> deleteInvitation(String orgId, String invitationId) {
        Asserts.assertNotNull(orgId, "organization ID");
        Asserts.assertNotNull(invitationId, "invitation ID");
        String url = this.baseUrl.newBuilder().addPathSegments(ORGS_PATH).addPathSegment(orgId).addPathSegment("invitations").addPathSegment(invitationId).build().toString();
        VoidRequest request = new VoidRequest(this.client, url, "DELETE");
        request.addHeader(AUTHORIZATION_HEADER, "Bearer " + this.apiToken);
        return request;
    }

    private void applyFilter(BaseFilter filter, HttpUrl.Builder builder) {
        if (filter != null) {
            for (Map.Entry<String, Object> e : filter.getAsMap().entrySet()) {
                builder.addQueryParameter(e.getKey(), String.valueOf(e.getValue()));
            }
        }
    }
}

