/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.client.mgmt;

import com.auth0.net.CustomRequest;
import com.auth0.net.Request;
import com.auth0.net.VoidRequest;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.HashMap;
import java.util.Map;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.Nullable;

class RequestBuilder<T> {
    private final OkHttpClient client;
    private final String method;
    private final HttpUrl.Builder url;
    private final TypeReference<T> target;
    @Nullable
    private Object body = null;
    private final Map<String, String> headers = new HashMap<String, String>();
    private final Map<String, Object> parameters = new HashMap<String, Object>();

    public RequestBuilder(OkHttpClient client, String method, HttpUrl baseUrl, TypeReference<T> target) {
        this.client = client;
        this.method = method;
        this.url = baseUrl.newBuilder();
        this.target = target;
    }

    public RequestBuilder<T> withHeader(String name, String value) {
        this.headers.put(name, value);
        return this;
    }

    public RequestBuilder<T> withParameter(String name, Object value) {
        this.parameters.put(name, value);
        return this;
    }

    public RequestBuilder<T> withBody(Object body) {
        this.body = body;
        return this;
    }

    public RequestBuilder<T> withPathSegments(String path) {
        this.url.addPathSegments(path);
        return this;
    }

    public Request<T> build() {
        String url = this.url.build().toString();
        CustomRequest request = "java.lang.Void".equals(this.target.getType().getTypeName()) ? new VoidRequest(this.client, url, this.method) : new CustomRequest<T>(this.client, url, this.method, this.target);
        if (this.body != null) {
            request.setBody(this.body);
        }
        this.headers.forEach(request::addHeader);
        this.parameters.forEach(request::addParameter);
        return request;
    }
}

