/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.client.mgmt;

import com.auth0.client.mgmt.BaseManagementEntity;
import com.auth0.client.mgmt.filter.ResourceServersFilter;
import com.auth0.json.mgmt.ResourceServer;
import com.auth0.json.mgmt.ResourceServersPage;
import com.auth0.net.CustomRequest;
import com.auth0.net.Request;
import com.auth0.net.VoidRequest;
import com.auth0.utils.Asserts;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.Map;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;

public class ResourceServerEntity
extends BaseManagementEntity {
    ResourceServerEntity(OkHttpClient client, HttpUrl baseUrl, String apiToken) {
        super(client, baseUrl, apiToken);
    }

    public Request<ResourceServersPage> list(ResourceServersFilter filter) {
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments("api/v2/resource-servers");
        if (filter != null) {
            for (Map.Entry<String, Object> e : filter.getAsMap().entrySet()) {
                builder.addQueryParameter(e.getKey(), String.valueOf(e.getValue()));
            }
        }
        String url = builder.build().toString();
        CustomRequest<ResourceServersPage> request = new CustomRequest<ResourceServersPage>(this.client, url, "GET", new TypeReference<ResourceServersPage>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }

    @Deprecated
    public Request<List<ResourceServer>> list() {
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments("api/v2/resource-servers");
        String url = builder.build().toString();
        CustomRequest<List<ResourceServer>> request = new CustomRequest<List<ResourceServer>>(this.client, url, "GET", new TypeReference<List<ResourceServer>>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }

    public Request<ResourceServer> get(String resourceServerIdOrIdentifier) {
        Asserts.assertNotNull(resourceServerIdOrIdentifier, "Resource server ID");
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments("api/v2/resource-servers").addPathSegment(resourceServerIdOrIdentifier);
        String url = builder.build().toString();
        CustomRequest<ResourceServer> request = new CustomRequest<ResourceServer>(this.client, url, "GET", new TypeReference<ResourceServer>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }

    public Request<ResourceServer> create(ResourceServer resourceServer) {
        Asserts.assertNotNull(resourceServer, "Resource server");
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments("api/v2/resource-servers");
        String url = builder.build().toString();
        CustomRequest<ResourceServer> request = new CustomRequest<ResourceServer>(this.client, url, "POST", new TypeReference<ResourceServer>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        request.setBody(resourceServer);
        return request;
    }

    public Request<Void> delete(String resourceServerId) {
        Asserts.assertNotNull(resourceServerId, "Resource server ID");
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments("api/v2/resource-servers").addPathSegment(resourceServerId);
        String url = builder.build().toString();
        VoidRequest request = new VoidRequest(this.client, url, "DELETE");
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }

    public Request<ResourceServer> update(String resourceServerId, ResourceServer resourceServer) {
        Asserts.assertNotNull(resourceServerId, "resourceServerId");
        Asserts.assertNotNull(resourceServer, "resourceServer");
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments("api/v2/resource-servers").addPathSegment(resourceServerId);
        String url = builder.build().toString();
        CustomRequest<ResourceServer> request = new CustomRequest<ResourceServer>(this.client, url, "PATCH", new TypeReference<ResourceServer>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        request.setBody(resourceServer);
        return request;
    }
}

