/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.client.mgmt;

import com.auth0.client.mgmt.BaseManagementEntity;
import com.auth0.client.mgmt.filter.PageFilter;
import com.auth0.client.mgmt.filter.RolesFilter;
import com.auth0.json.mgmt.Permission;
import com.auth0.json.mgmt.PermissionsPage;
import com.auth0.json.mgmt.Role;
import com.auth0.json.mgmt.RolesPage;
import com.auth0.json.mgmt.users.UsersPage;
import com.auth0.net.CustomRequest;
import com.auth0.net.Request;
import com.auth0.net.VoidRequest;
import com.auth0.utils.Asserts;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;

public class RolesEntity
extends BaseManagementEntity {
    RolesEntity(OkHttpClient client, HttpUrl baseUrl, String apiToken) {
        super(client, baseUrl, apiToken);
    }

    public Request<RolesPage> list(RolesFilter filter) {
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addEncodedPathSegments("api/v2/roles");
        if (filter != null) {
            for (Map.Entry<String, Object> e : filter.getAsMap().entrySet()) {
                builder.addQueryParameter(e.getKey(), String.valueOf(e.getValue()));
            }
        }
        String url = builder.build().toString();
        CustomRequest<RolesPage> request = new CustomRequest<RolesPage>(this.client, url, "GET", new TypeReference<RolesPage>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }

    public Request<Role> get(String roleId) {
        Asserts.assertNotNull(roleId, "role id");
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addEncodedPathSegments("api/v2/roles").addEncodedPathSegments(roleId);
        String url = builder.build().toString();
        CustomRequest<Role> request = new CustomRequest<Role>(this.client, url, "GET", new TypeReference<Role>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }

    public Request<Role> create(Role role) {
        Asserts.assertNotNull(role, "role");
        String url = this.baseUrl.newBuilder().addEncodedPathSegments("api/v2/roles").build().toString();
        CustomRequest<Role> request = new CustomRequest<Role>(this.client, url, "POST", new TypeReference<Role>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        request.setBody(role);
        return request;
    }

    public Request<Void> delete(String roleId) {
        Asserts.assertNotNull(roleId, "role id");
        String url = this.baseUrl.newBuilder().addEncodedPathSegments("api/v2/roles").addEncodedPathSegments(roleId).build().toString();
        VoidRequest request = new VoidRequest(this.client, url, "DELETE");
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }

    public Request<Role> update(String roleId, Role role) {
        Asserts.assertNotNull(roleId, "role id");
        Asserts.assertNotNull(role, "role");
        String url = this.baseUrl.newBuilder().addEncodedPathSegments("api/v2/roles").addEncodedPathSegments(roleId).build().toString();
        CustomRequest<Role> request = new CustomRequest<Role>(this.client, url, "PATCH", new TypeReference<Role>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        request.setBody(role);
        return request;
    }

    public Request<UsersPage> listUsers(String roleId, PageFilter filter) {
        Asserts.assertNotNull(roleId, "role id");
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addEncodedPathSegments("api/v2/roles").addEncodedPathSegments(roleId).addEncodedPathSegments("users");
        if (filter != null) {
            for (Map.Entry<String, Object> e : filter.getAsMap().entrySet()) {
                builder.addQueryParameter(e.getKey(), String.valueOf(e.getValue()));
            }
        }
        String url = builder.build().toString();
        CustomRequest<UsersPage> request = new CustomRequest<UsersPage>(this.client, url, "GET", new TypeReference<UsersPage>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }

    public Request<Void> assignUsers(String roleId, List<String> userIds) {
        Asserts.assertNotNull(roleId, "role id");
        Asserts.assertNotEmpty(userIds, "user ids");
        HashMap<String, List<String>> body = new HashMap<String, List<String>>();
        body.put("users", userIds);
        String url = this.baseUrl.newBuilder().addEncodedPathSegments("api/v2/roles").addEncodedPathSegments(roleId).addEncodedPathSegments("users").build().toString();
        VoidRequest request = new VoidRequest(this.client, url, "POST");
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        request.setBody(body);
        return request;
    }

    public Request<PermissionsPage> listPermissions(String roleId, PageFilter filter) {
        Asserts.assertNotNull(roleId, "role id");
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addEncodedPathSegments("api/v2/roles").addEncodedPathSegments(roleId).addEncodedPathSegments("permissions");
        if (filter != null) {
            for (Map.Entry<String, Object> e : filter.getAsMap().entrySet()) {
                builder.addQueryParameter(e.getKey(), String.valueOf(e.getValue()));
            }
        }
        String url = builder.build().toString();
        CustomRequest<PermissionsPage> request = new CustomRequest<PermissionsPage>(this.client, url, "GET", new TypeReference<PermissionsPage>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }

    public Request<Void> removePermissions(String roleId, List<Permission> permissions) {
        Asserts.assertNotNull(roleId, "role id");
        Asserts.assertNotEmpty(permissions, "permissions");
        HashMap<String, List<Permission>> body = new HashMap<String, List<Permission>>();
        body.put("permissions", permissions);
        String url = this.baseUrl.newBuilder().addEncodedPathSegments("api/v2/roles").addEncodedPathSegments(roleId).addEncodedPathSegments("permissions").build().toString();
        VoidRequest request = new VoidRequest(this.client, url, "DELETE");
        request.setBody(body);
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }

    public Request<Void> addPermissions(String roleId, List<Permission> permissions) {
        Asserts.assertNotNull(roleId, "role id");
        Asserts.assertNotEmpty(permissions, "permissions");
        HashMap<String, List<Permission>> body = new HashMap<String, List<Permission>>();
        body.put("permissions", permissions);
        String url = this.baseUrl.newBuilder().addEncodedPathSegments("api/v2/roles").addEncodedPathSegments(roleId).addEncodedPathSegments("permissions").build().toString();
        VoidRequest request = new VoidRequest(this.client, url, "POST");
        request.setBody(body);
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }
}

