/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.client.mgmt;

import com.auth0.client.mgmt.BaseManagementEntity;
import com.auth0.client.mgmt.filter.RulesFilter;
import com.auth0.json.mgmt.Rule;
import com.auth0.json.mgmt.RulesPage;
import com.auth0.net.CustomRequest;
import com.auth0.net.Request;
import com.auth0.net.VoidRequest;
import com.auth0.utils.Asserts;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.Map;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;

public class RulesEntity
extends BaseManagementEntity {
    RulesEntity(OkHttpClient client, HttpUrl baseUrl, String apiToken) {
        super(client, baseUrl, apiToken);
    }

    public Request<RulesPage> listAll(RulesFilter filter) {
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments("api/v2/rules");
        if (filter != null) {
            for (Map.Entry<String, Object> e : filter.getAsMap().entrySet()) {
                builder.addQueryParameter(e.getKey(), String.valueOf(e.getValue()));
            }
        }
        String url = builder.build().toString();
        CustomRequest<RulesPage> request = new CustomRequest<RulesPage>(this.client, url, "GET", new TypeReference<RulesPage>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }

    @Deprecated
    public Request<List<Rule>> list(RulesFilter filter) {
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments("api/v2/rules");
        if (filter != null) {
            for (Map.Entry<String, Object> e : filter.getAsMap().entrySet()) {
                if (e.getKey().equalsIgnoreCase("include_totals")) continue;
                builder.addQueryParameter(e.getKey(), String.valueOf(e.getValue()));
            }
        }
        String url = builder.build().toString();
        CustomRequest<List<Rule>> request = new CustomRequest<List<Rule>>(this.client, url, "GET", new TypeReference<List<Rule>>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }

    public Request<Rule> get(String ruleId, RulesFilter filter) {
        Asserts.assertNotNull(ruleId, "rule id");
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments("api/v2/rules").addPathSegment(ruleId);
        if (filter != null) {
            for (Map.Entry<String, Object> e : filter.getAsMap().entrySet()) {
                builder.addQueryParameter(e.getKey(), String.valueOf(e.getValue()));
            }
        }
        String url = builder.build().toString();
        CustomRequest<Rule> request = new CustomRequest<Rule>(this.client, url, "GET", new TypeReference<Rule>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }

    public Request<Rule> create(Rule rule) {
        Asserts.assertNotNull(rule, "rule");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/rules").build().toString();
        CustomRequest<Rule> request = new CustomRequest<Rule>(this.client, url, "POST", new TypeReference<Rule>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        request.setBody(rule);
        return request;
    }

    public Request<Void> delete(String ruleId) {
        Asserts.assertNotNull(ruleId, "rule id");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/rules").addPathSegment(ruleId).build().toString();
        VoidRequest request = new VoidRequest(this.client, url, "DELETE");
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }

    public Request<Rule> update(String ruleId, Rule rule) {
        Asserts.assertNotNull(ruleId, "rule id");
        Asserts.assertNotNull(rule, "rule");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/rules").addPathSegment(ruleId).build().toString();
        CustomRequest<Rule> request = new CustomRequest<Rule>(this.client, url, "PATCH", new TypeReference<Rule>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        request.setBody(rule);
        return request;
    }
}

