/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.client.mgmt;

import com.auth0.client.mgmt.BaseManagementEntity;
import com.auth0.json.mgmt.DailyStats;
import com.auth0.net.CustomRequest;
import com.auth0.net.Request;
import com.auth0.utils.Asserts;
import com.fasterxml.jackson.core.type.TypeReference;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;

public class StatsEntity
extends BaseManagementEntity {
    StatsEntity(OkHttpClient client, HttpUrl baseUrl, String apiToken) {
        super(client, baseUrl, apiToken);
    }

    public Request<Integer> getActiveUsersCount() {
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/stats/active-users").build().toString();
        CustomRequest<Integer> request = new CustomRequest<Integer>(this.client, url, "GET", new TypeReference<Integer>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }

    public Request<List<DailyStats>> getDailyStats(Date from, Date to) {
        Asserts.assertNotNull(from, "date from");
        Asserts.assertNotNull(to, "date to");
        String dateFrom = this.formatDate(from);
        String dateTo = this.formatDate(to);
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/stats/daily").addQueryParameter("from", dateFrom).addQueryParameter("to", dateTo).build().toString();
        CustomRequest<List<DailyStats>> request = new CustomRequest<List<DailyStats>>(this.client, url, "GET", new TypeReference<List<DailyStats>>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }

    protected String formatDate(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        return sdf.format(date);
    }
}

