/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.client.mgmt;

import com.auth0.client.mgmt.BaseManagementEntity;
import com.auth0.client.mgmt.filter.FieldsFilter;
import com.auth0.json.mgmt.tenants.Tenant;
import com.auth0.net.CustomRequest;
import com.auth0.net.Request;
import com.auth0.utils.Asserts;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Map;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;

public class TenantsEntity
extends BaseManagementEntity {
    TenantsEntity(OkHttpClient client, HttpUrl baseUrl, String apiToken) {
        super(client, baseUrl, apiToken);
    }

    public Request<Tenant> get(FieldsFilter filter) {
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments("api/v2/tenants/settings");
        if (filter != null) {
            for (Map.Entry<String, Object> e : filter.getAsMap().entrySet()) {
                builder.addQueryParameter(e.getKey(), String.valueOf(e.getValue()));
            }
        }
        String url = builder.build().toString();
        CustomRequest<Tenant> request = new CustomRequest<Tenant>(this.client, url, "GET", new TypeReference<Tenant>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }

    public Request<Tenant> update(Tenant tenant) {
        Asserts.assertNotNull(tenant, "tenant");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/tenants/settings").build().toString();
        CustomRequest<Tenant> request = new CustomRequest<Tenant>(this.client, url, "PATCH", new TypeReference<Tenant>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        request.setBody(tenant);
        return request;
    }
}

