/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.client.mgmt;

import com.auth0.client.mgmt.BaseManagementEntity;
import com.auth0.json.mgmt.userblocks.UserBlocks;
import com.auth0.net.CustomRequest;
import com.auth0.net.Request;
import com.auth0.net.VoidRequest;
import com.auth0.utils.Asserts;
import com.fasterxml.jackson.core.type.TypeReference;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;

public class UserBlocksEntity
extends BaseManagementEntity {
    UserBlocksEntity(OkHttpClient client, HttpUrl baseUrl, String apiToken) {
        super(client, baseUrl, apiToken);
    }

    public Request<UserBlocks> getByIdentifier(String identifier) {
        Asserts.assertNotNull(identifier, "identifier");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/user-blocks").addQueryParameter("identifier", identifier).build().toString();
        CustomRequest<UserBlocks> request = new CustomRequest<UserBlocks>(this.client, url, "GET", new TypeReference<UserBlocks>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }

    public Request<Void> deleteByIdentifier(String identifier) {
        Asserts.assertNotNull(identifier, "identifier");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/user-blocks").addQueryParameter("identifier", identifier).build().toString();
        VoidRequest request = new VoidRequest(this.client, url, "DELETE");
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }

    public Request<UserBlocks> get(String userId) {
        Asserts.assertNotNull(userId, "user id");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/user-blocks").addPathSegment(userId).build().toString();
        CustomRequest<UserBlocks> request = new CustomRequest<UserBlocks>(this.client, url, "GET", new TypeReference<UserBlocks>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }

    public Request<Void> delete(String userId) {
        Asserts.assertNotNull(userId, "user id");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/user-blocks").addPathSegment(userId).build().toString();
        VoidRequest request = new VoidRequest(this.client, url, "DELETE");
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }
}

