/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.client.mgmt;

import com.auth0.client.mgmt.BaseManagementEntity;
import com.auth0.client.mgmt.filter.BaseFilter;
import com.auth0.client.mgmt.filter.FieldsFilter;
import com.auth0.client.mgmt.filter.LogEventFilter;
import com.auth0.client.mgmt.filter.PageFilter;
import com.auth0.client.mgmt.filter.UserFilter;
import com.auth0.json.mgmt.Permission;
import com.auth0.json.mgmt.PermissionsPage;
import com.auth0.json.mgmt.RolesPage;
import com.auth0.json.mgmt.guardian.Enrollment;
import com.auth0.json.mgmt.logevents.LogEventsPage;
import com.auth0.json.mgmt.organizations.OrganizationsPage;
import com.auth0.json.mgmt.users.Identity;
import com.auth0.json.mgmt.users.RecoveryCode;
import com.auth0.json.mgmt.users.User;
import com.auth0.json.mgmt.users.UsersPage;
import com.auth0.net.CustomRequest;
import com.auth0.net.EmptyBodyRequest;
import com.auth0.net.Request;
import com.auth0.net.VoidRequest;
import com.auth0.utils.Asserts;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;

public class UsersEntity
extends BaseManagementEntity {
    UsersEntity(OkHttpClient client, HttpUrl baseUrl, String apiToken) {
        super(client, baseUrl, apiToken);
    }

    public Request<List<User>> listByEmail(String email, FieldsFilter filter) {
        Asserts.assertNotNull(email, "email");
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments("api/v2/users-by-email");
        builder.addQueryParameter("email", email);
        if (filter != null) {
            for (Map.Entry<String, Object> e : filter.getAsMap().entrySet()) {
                builder.addQueryParameter(e.getKey(), String.valueOf(e.getValue()));
            }
        }
        String url = builder.build().toString();
        CustomRequest<List<User>> request = new CustomRequest<List<User>>(this.client, url, "GET", new TypeReference<List<User>>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }

    public Request<UsersPage> list(UserFilter filter) {
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments("api/v2/users");
        UsersEntity.encodeAndAddQueryParam(builder, filter);
        String url = builder.build().toString();
        CustomRequest<UsersPage> request = new CustomRequest<UsersPage>(this.client, url, "GET", new TypeReference<UsersPage>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }

    public Request<User> get(String userId, UserFilter filter) {
        Asserts.assertNotNull(userId, "user id");
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments("api/v2/users").addPathSegment(userId);
        if (filter != null) {
            for (Map.Entry<String, Object> e : filter.getAsMap().entrySet()) {
                builder.addQueryParameter(e.getKey(), String.valueOf(e.getValue()));
            }
        }
        String url = builder.build().toString();
        CustomRequest<User> request = new CustomRequest<User>(this.client, url, "GET", new TypeReference<User>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }

    public Request<User> create(User user) {
        Asserts.assertNotNull(user, "user");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/users").build().toString();
        CustomRequest<User> request = new CustomRequest<User>(this.client, url, "POST", new TypeReference<User>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        request.setBody(user);
        return request;
    }

    public Request<Void> delete(String userId) {
        Asserts.assertNotNull(userId, "user id");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/users").addPathSegment(userId).build().toString();
        VoidRequest request = new VoidRequest(this.client, url, "DELETE");
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }

    public Request<User> update(String userId, User user) {
        Asserts.assertNotNull(userId, "user id");
        Asserts.assertNotNull(user, "user");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/users").addPathSegment(userId).build().toString();
        CustomRequest<User> request = new CustomRequest<User>(this.client, url, "PATCH", new TypeReference<User>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        request.setBody(user);
        return request;
    }

    public Request<List<Enrollment>> getEnrollments(String userId) {
        Asserts.assertNotNull(userId, "user id");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/users").addPathSegment(userId).addPathSegment("enrollments").build().toString();
        CustomRequest<List<Enrollment>> request = new CustomRequest<List<Enrollment>>(this.client, url, "GET", new TypeReference<List<Enrollment>>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }

    public Request<LogEventsPage> getLogEvents(String userId, LogEventFilter filter) {
        Asserts.assertNotNull(userId, "user id");
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments("api/v2/users").addPathSegment(userId).addPathSegment("logs");
        UsersEntity.encodeAndAddQueryParam(builder, filter);
        String url = builder.build().toString();
        CustomRequest<LogEventsPage> request = new CustomRequest<LogEventsPage>(this.client, url, "GET", new TypeReference<LogEventsPage>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }

    public Request<Void> deleteAllAuthenticators(String userId) {
        Asserts.assertNotNull(userId, "user id");
        return this.voidRequest("DELETE", builder -> builder.withPathSegments(String.format("api/v2/users/%s/authenticators", userId)));
    }

    public Request<Void> deleteMultifactorProvider(String userId, String provider) {
        Asserts.assertNotNull(userId, "user id");
        Asserts.assertNotNull(provider, "provider");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/users").addPathSegment(userId).addPathSegment("multifactor").addPathSegment(provider).build().toString();
        VoidRequest request = new VoidRequest(this.client, url, "DELETE");
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }

    public Request<RecoveryCode> rotateRecoveryCode(String userId) {
        Asserts.assertNotNull(userId, "user id");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/users").addPathSegment(userId).addPathSegment("recovery-code-regeneration").build().toString();
        EmptyBodyRequest<RecoveryCode> request = new EmptyBodyRequest<RecoveryCode>(this.client, url, "POST", new TypeReference<RecoveryCode>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }

    public Request<List<Identity>> linkIdentity(String primaryUserId, String secondaryUserId, String provider, String connectionId) {
        Asserts.assertNotNull(primaryUserId, "primary user id");
        Asserts.assertNotNull(secondaryUserId, "secondary user id");
        Asserts.assertNotNull(provider, "provider");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/users").addPathSegment(primaryUserId).addPathSegment("identities").build().toString();
        CustomRequest<List<Identity>> request = new CustomRequest<List<Identity>>(this.client, url, "POST", new TypeReference<List<Identity>>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        request.addParameter("provider", provider);
        request.addParameter("user_id", secondaryUserId);
        if (connectionId != null) {
            request.addParameter("connection_id", connectionId);
        }
        return request;
    }

    public Request<List<Identity>> linkIdentity(String primaryUserId, String secondaryIdToken) {
        Asserts.assertNotNull(primaryUserId, "primary user id");
        Asserts.assertNotNull(secondaryIdToken, "secondary id token");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/users").addPathSegment(primaryUserId).addPathSegment("identities").build().toString();
        CustomRequest<List<Identity>> request = new CustomRequest<List<Identity>>(this.client, url, "POST", new TypeReference<List<Identity>>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        request.addParameter("link_with", secondaryIdToken);
        return request;
    }

    public Request<List<Identity>> unlinkIdentity(String primaryUserId, String secondaryUserId, String provider) {
        Asserts.assertNotNull(primaryUserId, "primary user id");
        Asserts.assertNotNull(secondaryUserId, "secondary user id");
        Asserts.assertNotNull(provider, "provider");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/users").addPathSegment(primaryUserId).addPathSegment("identities").addPathSegment(provider).addPathSegment(secondaryUserId).build().toString();
        CustomRequest<List<Identity>> request = new CustomRequest<List<Identity>>(this.client, url, "DELETE", new TypeReference<List<Identity>>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }

    public Request<PermissionsPage> listPermissions(String userId, PageFilter filter) {
        Asserts.assertNotNull(userId, "user id");
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments("api/v2/users").addPathSegments(userId).addPathSegments("permissions");
        if (filter != null) {
            for (Map.Entry<String, Object> e : filter.getAsMap().entrySet()) {
                builder.addQueryParameter(e.getKey(), String.valueOf(e.getValue()));
            }
        }
        String url = builder.build().toString();
        CustomRequest<PermissionsPage> request = new CustomRequest<PermissionsPage>(this.client, url, "GET", new TypeReference<PermissionsPage>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }

    public Request<Void> removePermissions(String userId, List<Permission> permissions) {
        Asserts.assertNotNull(userId, "user id");
        Asserts.assertNotEmpty(permissions, "permissions");
        HashMap<String, List<Permission>> body = new HashMap<String, List<Permission>>();
        body.put("permissions", permissions);
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/users").addPathSegments(userId).addPathSegments("permissions").build().toString();
        VoidRequest request = new VoidRequest(this.client, url, "DELETE");
        request.setBody(body);
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }

    public Request<Void> addPermissions(String userId, List<Permission> permissions) {
        Asserts.assertNotNull(userId, "user id");
        Asserts.assertNotEmpty(permissions, "permissions");
        HashMap<String, List<Permission>> body = new HashMap<String, List<Permission>>();
        body.put("permissions", permissions);
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/users").addPathSegments(userId).addPathSegments("permissions").build().toString();
        VoidRequest request = new VoidRequest(this.client, url, "POST");
        request.setBody(body);
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }

    public Request<RolesPage> listRoles(String userId, PageFilter filter) {
        Asserts.assertNotNull(userId, "user id");
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments("api/v2/users").addPathSegments(userId).addPathSegments("roles");
        if (filter != null) {
            for (Map.Entry<String, Object> e : filter.getAsMap().entrySet()) {
                builder.addQueryParameter(e.getKey(), String.valueOf(e.getValue()));
            }
        }
        String url = builder.build().toString();
        CustomRequest<RolesPage> request = new CustomRequest<RolesPage>(this.client, url, "GET", new TypeReference<RolesPage>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }

    public Request<Void> removeRoles(String userId, List<String> roleIds) {
        Asserts.assertNotNull(userId, "user id");
        Asserts.assertNotEmpty(roleIds, "role ids");
        HashMap<String, List<String>> body = new HashMap<String, List<String>>();
        body.put("roles", roleIds);
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/users").addPathSegments(userId).addPathSegments("roles").build().toString();
        VoidRequest request = new VoidRequest(this.client, url, "DELETE");
        request.setBody(body);
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }

    public Request<Void> addRoles(String userId, List<String> roleIds) {
        Asserts.assertNotNull(userId, "user id");
        Asserts.assertNotEmpty(roleIds, "role ids");
        HashMap<String, List<String>> body = new HashMap<String, List<String>>();
        body.put("roles", roleIds);
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/users").addPathSegments(userId).addPathSegments("roles").build().toString();
        VoidRequest request = new VoidRequest(this.client, url, "POST");
        request.setBody(body);
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }

    public Request<OrganizationsPage> getOrganizations(String userId, PageFilter filter) {
        Asserts.assertNotNull(userId, "user ID");
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments("api/v2/users").addPathSegment(userId).addPathSegment("organizations");
        if (filter != null) {
            for (Map.Entry<String, Object> e : filter.getAsMap().entrySet()) {
                builder.addQueryParameter(e.getKey(), String.valueOf(e.getValue()));
            }
        }
        String url = builder.build().toString();
        CustomRequest<OrganizationsPage> request = new CustomRequest<OrganizationsPage>(this.client, url, "GET", new TypeReference<OrganizationsPage>(){});
        request.addHeader("Authorization", "Bearer " + this.apiToken);
        return request;
    }

    private static void encodeAndAddQueryParam(HttpUrl.Builder builder, BaseFilter filter) {
        if (filter != null) {
            for (Map.Entry<String, Object> e : filter.getAsMap().entrySet()) {
                if ("q".equals(e.getKey())) {
                    builder.addEncodedQueryParameter(e.getKey(), String.valueOf(e.getValue()));
                    continue;
                }
                builder.addQueryParameter(e.getKey(), String.valueOf(e.getValue()));
            }
        }
    }
}

