/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.json.mgmt;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.IOException;
import java.util.List;

public abstract class PageDeserializer<T, U>
extends StdDeserializer<T> {
    private final String itemsPropertyName;
    private final Class<U> uClazz;
    private static final ObjectMapper mapper = new ObjectMapper();

    protected PageDeserializer(Class<U> clazz, String arrayName) {
        super(Object.class);
        this.uClazz = clazz;
        this.itemsPropertyName = arrayName;
    }

    public T deserialize(JsonParser p, DeserializationContext ctx) throws IOException {
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        if (node.isArray()) {
            return this.createPage(this.getArrayElements((ArrayNode)node));
        }
        Integer start = this.getIntegerValue(node.get("start"));
        Integer length = this.getIntegerValue(node.get("length"));
        Integer total = this.getIntegerValue(node.get("total"));
        Integer limit = this.getIntegerValue(node.get("limit"));
        String next = this.getStringValue(node.get("next"));
        ArrayNode array = (ArrayNode)node.get(this.itemsPropertyName);
        return this.createPage(start, length, total, limit, next, this.getArrayElements(array));
    }

    protected abstract T createPage(List<U> var1);

    protected abstract T createPage(Integer var1, Integer var2, Integer var3, Integer var4, List<U> var5);

    protected T createPage(Integer start, Integer length, Integer total, Integer limit, String next, List<U> items) {
        return this.createPage(start, length, total, limit, items);
    }

    private Integer getIntegerValue(JsonNode node) {
        if (node == null || node.isNull()) {
            return null;
        }
        return node.intValue();
    }

    private String getStringValue(JsonNode node) {
        if (node == null || node.isNull()) {
            return null;
        }
        return node.textValue();
    }

    private List<U> getArrayElements(ArrayNode array) throws IOException {
        CollectionType type = mapper.getTypeFactory().constructCollectionType(List.class, this.uClazz);
        return (List)mapper.readerFor((JavaType)type).readValue((JsonNode)array);
    }
}

