/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.net;

import com.auth0.exception.Auth0Exception;
import com.auth0.net.Request;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

public abstract class BaseRequest<T>
implements Request<T> {
    private final OkHttpClient client;

    BaseRequest(OkHttpClient client) {
        this.client = client;
    }

    protected abstract okhttp3.Request createRequest() throws Auth0Exception;

    protected abstract T parseResponse(Response var1) throws Auth0Exception;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T execute() throws Auth0Exception {
        okhttp3.Request request = this.createRequest();
        try (Response response = this.client.newCall(request).execute();){
            T t = this.parseResponse(response);
            return t;
        }
        catch (Auth0Exception e) {
            throw e;
        }
        catch (IOException e) {
            throw new Auth0Exception("Failed to execute request", e);
        }
    }

    @Override
    public CompletableFuture<T> executeAsync() {
        okhttp3.Request request;
        final CompletableFuture future = new CompletableFuture();
        try {
            request = this.createRequest();
        }
        catch (Auth0Exception e) {
            future.completeExceptionally(e);
            return future;
        }
        this.client.newCall(request).enqueue(new Callback(){

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new Auth0Exception("Failed to execute request", e));
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try {
                    Object parsedResponse = BaseRequest.this.parseResponse(response);
                    future.complete(parsedResponse);
                }
                catch (Auth0Exception e) {
                    future.completeExceptionally(e);
                }
            }
        });
        return future;
    }
}

