/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.net;

import com.auth0.net.CustomizableRequest;
import com.auth0.net.ExtendedBaseRequest;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;

public class CustomRequest<T>
extends ExtendedBaseRequest<T>
implements CustomizableRequest<T> {
    private static final String CONTENT_TYPE_APPLICATION_JSON = "application/json";
    private final ObjectMapper mapper;
    private final TypeReference<T> tType;
    private final Map<String, Object> parameters;
    private Object body;

    CustomRequest(OkHttpClient client, String url, String method, ObjectMapper mapper, TypeReference<T> tType) {
        super(client, url, method, mapper);
        this.mapper = mapper;
        this.tType = tType;
        this.parameters = new HashMap<String, Object>();
    }

    public CustomRequest(OkHttpClient client, String url, String method, TypeReference<T> tType) {
        this(client, url, method, new ObjectMapper(), tType);
    }

    @Override
    protected RequestBody createRequestBody() throws IOException {
        if (this.body == null && this.parameters.isEmpty()) {
            return null;
        }
        byte[] jsonBody = this.mapper.writeValueAsBytes(this.body != null ? this.body : this.parameters);
        return RequestBody.create((MediaType)MediaType.parse((String)CONTENT_TYPE_APPLICATION_JSON), (byte[])jsonBody);
    }

    @Override
    protected T readResponseBody(ResponseBody body) throws IOException {
        String payload = body.string();
        return (T)this.mapper.readValue(payload, this.tType);
    }

    @Override
    public CustomRequest<T> addHeader(String name, String value) {
        super.addHeader(name, value);
        return this;
    }

    @Override
    public CustomRequest<T> addParameter(String name, Object value) {
        this.parameters.put(name, value);
        return this;
    }

    @Override
    public CustomRequest<T> setBody(Object value) {
        this.body = value;
        return this;
    }
}

