/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.utils;

import java.util.Collection;
import okhttp3.HttpUrl;

public abstract class Asserts {
    public static void assertNotNull(Object value, String name) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("'%s' cannot be null!", name));
        }
    }

    public static void assertValidUrl(String value, String name) {
        boolean isValidCustomSchemeUrl;
        if (value == null) {
            throw new IllegalArgumentException(String.format("'%s' must be a valid URL!", name));
        }
        boolean isValidUrl = HttpUrl.parse((String)value) != null;
        boolean bl = isValidCustomSchemeUrl = value.contains(":") && HttpUrl.parse((String)value.replaceFirst(value.substring(0, value.indexOf(":")), "https")) != null;
        if (!isValidUrl && !isValidCustomSchemeUrl) {
            throw new IllegalArgumentException(String.format("'%s' must be a valid URL!", name));
        }
    }

    public static void assertNotEmpty(Collection<?> value, String name) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("'%s' cannot be null!", name));
        }
        if (value.size() == 0) {
            throw new IllegalArgumentException(String.format("'%s' cannot be empty!", name));
        }
    }
}

