/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.utils.tokens;

import com.auth0.exception.IdTokenValidationException;
import com.auth0.exception.PublicKeyProviderException;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.RSAKeyProvider;
import com.auth0.utils.tokens.PublicKeyProvider;
import com.auth0.utils.tokens.SignatureVerifier;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;

class RS256SignatureVerifier
extends SignatureVerifier {
    RS256SignatureVerifier(PublicKeyProvider publicKeyProvider) {
        super(RS256SignatureVerifier.getAlgorithm(publicKeyProvider));
    }

    private static Algorithm getAlgorithm(final PublicKeyProvider publicKeyProvider) {
        return Algorithm.RSA256((RSAKeyProvider)new RSAKeyProvider(){

            public RSAPublicKey getPublicKeyById(String keyId) {
                try {
                    return publicKeyProvider.getPublicKeyById(keyId);
                }
                catch (PublicKeyProviderException pke) {
                    throw new IdTokenValidationException(String.format("Could not find a public key for Key ID (kid) \"%s\"", keyId), pke);
                }
            }

            public RSAPrivateKey getPrivateKey() {
                return null;
            }

            public String getPrivateKeyId() {
                return null;
            }
        });
    }
}

