/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.jobstream;

import io.atomix.cluster.messaging.ClusterEventService;
import io.camunda.zeebe.broker.jobstream.RemoteJobStream;
import io.camunda.zeebe.engine.processing.streamprocessor.ActivatedJob;
import io.camunda.zeebe.engine.processing.streamprocessor.JobActivationProperties;
import io.camunda.zeebe.engine.processing.streamprocessor.JobStreamer;
import io.camunda.zeebe.transport.stream.api.RemoteStreamer;
import java.util.Optional;
import org.agrona.DirectBuffer;

public final class RemoteJobStreamer
implements JobStreamer {
    private static final String JOBS_AVAILABLE_TOPIC = "jobsAvailable";
    private final RemoteStreamer<JobActivationProperties, ActivatedJob> delegate;
    private final ClusterEventService eventService;

    public RemoteJobStreamer(RemoteStreamer<JobActivationProperties, ActivatedJob> delegate, ClusterEventService eventService) {
        this.delegate = delegate;
        this.eventService = eventService;
    }

    public void notifyWorkAvailable(String jobType) {
        this.eventService.broadcast(JOBS_AVAILABLE_TOPIC, (Object)jobType);
    }

    public Optional<JobStreamer.JobStream> streamFor(DirectBuffer jobType) {
        return this.delegate.streamFor(jobType).map(RemoteJobStream::new);
    }
}

