/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.partitioning;

import io.atomix.cluster.ClusterMembershipService;
import io.atomix.cluster.messaging.ClusterCommunicationService;
import io.atomix.primitive.partition.ManagedPartitionGroup;
import io.atomix.primitive.partition.ManagedPartitionService;
import io.atomix.primitive.partition.impl.DefaultPartitionService;
import io.atomix.raft.partition.RaftPartitionGroup;
import io.camunda.zeebe.broker.PartitionListener;
import io.camunda.zeebe.broker.clustering.ClusterServices;
import io.camunda.zeebe.broker.exporter.repo.ExporterRepository;
import io.camunda.zeebe.broker.partitioning.MultiPartitionAdminAccess;
import io.camunda.zeebe.broker.partitioning.PartitionAdminAccess;
import io.camunda.zeebe.broker.partitioning.PartitionFactory;
import io.camunda.zeebe.broker.partitioning.PartitionManager;
import io.camunda.zeebe.broker.partitioning.RaftPartitionGroupFactory;
import io.camunda.zeebe.broker.partitioning.topology.TopologyManager;
import io.camunda.zeebe.broker.partitioning.topology.TopologyManagerImpl;
import io.camunda.zeebe.broker.partitioning.topology.TopologyPartitionListener;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.monitoring.BrokerHealthCheckService;
import io.camunda.zeebe.broker.system.monitoring.DiskSpaceUsageMonitor;
import io.camunda.zeebe.broker.system.partitions.PartitionHealthBroadcaster;
import io.camunda.zeebe.broker.system.partitions.ZeebePartition;
import io.camunda.zeebe.broker.transport.commandapi.CommandApiService;
import io.camunda.zeebe.engine.processing.streamprocessor.JobStreamer;
import io.camunda.zeebe.protocol.impl.encoding.BrokerInfo;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ActorSchedulingService;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.snapshots.ReceivableSnapshotStoreFactory;
import io.camunda.zeebe.snapshots.impl.FileBasedSnapshotStoreFactory;
import io.camunda.zeebe.transport.impl.AtomixServerTransport;
import io.camunda.zeebe.util.health.HealthStatus;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PartitionManagerImpl
implements PartitionManager,
TopologyManager {
    public static final String GROUP_NAME = "raft-partition";
    private static final Logger LOGGER = LoggerFactory.getLogger(PartitionManagerImpl.class);
    private volatile CompletableFuture<Void> closeFuture;
    private final BrokerHealthCheckService healthCheckService;
    private final ActorSchedulingService actorSchedulingService;
    private ManagedPartitionService partitionService;
    private RaftPartitionGroup partitionGroup;
    private TopologyManagerImpl topologyManager;
    private final List<ZeebePartition> partitions = new ArrayList<ZeebePartition>();
    private final DiskSpaceUsageMonitor diskSpaceUsageMonitor;
    private final BrokerCfg brokerCfg;
    private final BrokerInfo localBroker;
    private final FileBasedSnapshotStoreFactory snapshotStoreFactory;
    private final List<PartitionListener> partitionListeners;
    private final ClusterServices clusterServices;
    private final CommandApiService commandApiService;
    private final ExporterRepository exporterRepository;
    private final AtomixServerTransport gatewayBrokerTransport;
    private final JobStreamer jobStreamer;

    public PartitionManagerImpl(ActorSchedulingService actorSchedulingService, BrokerCfg brokerCfg, BrokerInfo localBroker, ClusterServices clusterServices, BrokerHealthCheckService healthCheckService, DiskSpaceUsageMonitor diskSpaceUsageMonitor, List<PartitionListener> partitionListeners, CommandApiService commandApiService, ExporterRepository exporterRepository, AtomixServerTransport gatewayBrokerTransport, JobStreamer jobStreamer) {
        this.gatewayBrokerTransport = gatewayBrokerTransport;
        this.snapshotStoreFactory = new FileBasedSnapshotStoreFactory(actorSchedulingService, localBroker.getNodeId());
        this.brokerCfg = brokerCfg;
        this.localBroker = localBroker;
        this.actorSchedulingService = actorSchedulingService;
        this.clusterServices = clusterServices;
        this.healthCheckService = healthCheckService;
        this.diskSpaceUsageMonitor = diskSpaceUsageMonitor;
        this.commandApiService = commandApiService;
        this.exporterRepository = exporterRepository;
        this.jobStreamer = jobStreamer;
        this.partitionGroup = new RaftPartitionGroupFactory().buildRaftPartitionGroup(brokerCfg, (ReceivableSnapshotStoreFactory)this.snapshotStoreFactory);
        ClusterMembershipService membershipService = clusterServices.getMembershipService();
        ClusterCommunicationService communicationService = clusterServices.getCommunicationService();
        this.partitionService = new DefaultPartitionService(membershipService, communicationService, (ManagedPartitionGroup)this.partitionGroup);
        this.partitionListeners = new ArrayList<PartitionListener>(partitionListeners);
        this.topologyManager = new TopologyManagerImpl(membershipService, localBroker);
        this.partitionListeners.add(this.topologyManager);
    }

    @Override
    public ManagedPartitionGroup getPartitionGroup() {
        return this.partitionGroup;
    }

    public PartitionAdminAccess createAdminAccess(ConcurrencyControl concurrencyControl) {
        return new MultiPartitionAdminAccess(concurrencyControl, this.partitions.stream().collect(Collectors.toMap(ZeebePartition::getPartitionId, ZeebePartition::createAdminAccess)));
    }

    public CompletableFuture<Void> start() {
        if (this.closeFuture != null) {
            return CompletableFuture.failedFuture(new IllegalStateException("PartitionManager is closed"));
        }
        this.actorSchedulingService.submitActor((Actor)this.topologyManager);
        return this.partitionService.start().thenApply(ps -> {
            LOGGER.info("Registering Partition Manager");
            this.healthCheckService.registerPartitionManager(this);
            LOGGER.info("Starting partitions");
            PartitionFactory partitionFactory = new PartitionFactory(this.actorSchedulingService, this.brokerCfg, this.localBroker, this.commandApiService, this.snapshotStoreFactory, this.clusterServices, this.exporterRepository, this.healthCheckService, this.diskSpaceUsageMonitor, this.gatewayBrokerTransport, this.jobStreamer);
            this.partitions.addAll(partitionFactory.constructPartitions(this.partitionGroup, this.partitionListeners, this.topologyManager, this.brokerCfg.getExperimental().getFeatures().toFeatureFlags()));
            CompletableFuture[] futures = (CompletableFuture[])this.partitions.stream().map(partition -> CompletableFuture.runAsync(() -> this.startPartition((ZeebePartition)partition))).toArray(CompletableFuture[]::new);
            CompletableFuture.allOf(futures).join();
            return null;
        });
    }

    private void startPartition(ZeebePartition zeebePartition) {
        this.actorSchedulingService.submitActor((Actor)zeebePartition).join();
        zeebePartition.addFailureListener(new PartitionHealthBroadcaster(zeebePartition.getPartitionId(), this::onHealthChanged));
        this.diskSpaceUsageMonitor.addDiskUsageListener(zeebePartition);
    }

    public CompletableFuture<Void> stop() {
        if (this.closeFuture == null) {
            this.closeFuture = ((CompletableFuture)CompletableFuture.runAsync(this::stopPartitions).whenComplete((ok, error) -> {
                this.logErrorIfApplicable((Throwable)error);
                this.partitionService.stop().join();
            })).whenComplete((ok, error) -> {
                this.logErrorIfApplicable((Throwable)error);
                this.partitionGroup = null;
                this.partitionService = null;
                this.topologyManager.close();
                this.topologyManager = null;
            });
        }
        return this.closeFuture;
    }

    private void logErrorIfApplicable(Throwable error) {
        if (error != null) {
            LOGGER.error(error.getMessage(), error);
        }
    }

    private void stopPartitions() {
        CompletableFuture[] futures = (CompletableFuture[])this.partitions.stream().map(partition -> CompletableFuture.runAsync(() -> this.stopPartition((ZeebePartition)partition))).toArray(CompletableFuture[]::new);
        CompletableFuture.allOf(futures).join();
    }

    private void stopPartition(ZeebePartition partition) {
        this.diskSpaceUsageMonitor.removeDiskUsageListener(partition);
        this.healthCheckService.removeMonitoredPartition(partition.getPartitionId());
        partition.close();
    }

    public String toString() {
        return "PartitionManagerImpl{partitionService=" + this.partitionService + ", partitionGroup=" + this.partitionGroup + ", partitions=" + this.partitions + "}";
    }

    public void onHealthChanged(int i, HealthStatus healthStatus) {
        this.topologyManager.onHealthChanged(i, healthStatus);
    }

    @Override
    public void removeTopologyPartitionListener(TopologyPartitionListener listener) {
        this.topologyManager.removeTopologyPartitionListener(listener);
    }

    @Override
    public void addTopologyPartitionListener(TopologyPartitionListener listener) {
        this.topologyManager.addTopologyPartitionListener(listener);
    }

    public List<ZeebePartition> getPartitions() {
        return this.partitions;
    }
}

